/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.EventInformation;

public class EventInformationImpl
extends AbstractISUPParameter
implements EventInformation {
    private static final int _TURN_ON = 1;
    private static final int _TURN_OFF = 0;
    private int eventIndicator;
    private boolean eventPresentationRestrictedIndicator;

    public EventInformationImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public EventInformationImpl() {
    }

    public EventInformationImpl(int eventIndicator) {
        this.eventIndicator = eventIndicator;
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 1) {
            throw new ParameterException("byte[] must not be null or have different size than 1");
        }
        this.eventIndicator = b[0] & 0x7F;
        this.eventPresentationRestrictedIndicator = (b[0] >> 7 & 1) == 1;
        return 1;
    }

    @Override
    public byte[] encode() throws ParameterException {
        byte[] b = new byte[]{(byte)(this.eventIndicator & 0x7F)};
        b[0] = (byte)(b[0] | (byte)((this.eventPresentationRestrictedIndicator ? 1 : 0) << 7));
        return b;
    }

    public int getEventIndicator() {
        return this.eventIndicator;
    }

    public void setEventIndicator(int eventIndicator) {
        this.eventIndicator = eventIndicator;
    }

    public boolean isEventPresentationRestrictedIndicator() {
        return this.eventPresentationRestrictedIndicator;
    }

    public void setEventPresentationRestrictedIndicator(boolean eventPresentationRestrictedIndicator) {
        this.eventPresentationRestrictedIndicator = eventPresentationRestrictedIndicator;
    }

    public int getCode() {
        return 36;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EventInformation [");
        sb.append("eventIndicator=");
        sb.append(this.eventIndicator);
        sb.append(", ");
        sb.append("eventPresentationRestrictedIndicator=");
        sb.append(this.eventPresentationRestrictedIndicator);
        sb.append("]");
        return sb.toString();
    }
}

