/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.ConnectedNumber;

public class ConnectedNumberImpl
extends AbstractNAINumber
implements ConnectedNumber {
    protected int numberingPlanIndicator;
    protected int addressRepresentationRestrictedIndicator;
    protected int screeningIndicator;

    public ConnectedNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public ConnectedNumberImpl() {
    }

    public ConnectedNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public ConnectedNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int addressRepresentationREstrictedIndicator, int screeningIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
        this.screeningIndicator = screeningIndicator;
    }

    @Override
    public int encodeHeader(ByteArrayOutputStream bos) {
        this.doAddressPresentationRestricted();
        return super.encodeHeader(bos);
    }

    @Override
    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.addressRepresentationRestrictedIndicator = (b & 0xC) >> 2;
        this.screeningIndicator = b & 3;
        return 1;
    }

    protected void doAddressPresentationRestricted() {
        if (this.addressRepresentationRestrictedIndicator == 2) {
            this.oddFlag = 0;
            this.natureOfAddresIndicator = 0;
            this.numberingPlanIndicator = 0;
            this.screeningIndicator = 3;
            this.setAddress("");
        }
    }

    @Override
    public int encodeBody(ByteArrayOutputStream bos) {
        int c = this.numberingPlanIndicator << 4;
        c |= this.addressRepresentationRestrictedIndicator << 2;
        bos.write((c |= this.screeningIndicator) & 0x7F);
        return 1;
    }

    @Override
    protected boolean skipDigits() {
        return this.addressRepresentationRestrictedIndicator == 2;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getAddressRepresentationRestrictedIndicator() {
        return this.addressRepresentationRestrictedIndicator;
    }

    public void setAddressRepresentationRestrictedIndicator(int addressRepresentationREstrictedIndicator) {
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
    }

    public int getScreeningIndicator() {
        return this.screeningIndicator;
    }

    public void setScreeningIndicator(int screeningIndicator) {
        this.screeningIndicator = screeningIndicator;
    }

    public int getCode() {
        return 33;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConnectedNumber [");
        sb.append("natureOfAddresIndicator=");
        sb.append(this.natureOfAddresIndicator);
        sb.append(", ");
        sb.append("numberingPlanIndicator=");
        sb.append(this.numberingPlanIndicator);
        sb.append(", ");
        sb.append("addressRepresentationRestrictedIndicator=");
        sb.append(this.addressRepresentationRestrictedIndicator);
        sb.append(", ");
        sb.append("screeningIndicator=");
        sb.append(this.screeningIndicator);
        sb.append("]");
        return sb.toString();
    }
}

