/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.CircuitStateIndicator;

public class CircuitStateIndicatorImpl
extends AbstractISUPParameter
implements CircuitStateIndicator {
    private byte[] circuitState = null;

    public CircuitStateIndicatorImpl(byte[] circuitState) throws ParameterException {
        this.decode(circuitState);
    }

    public CircuitStateIndicatorImpl() {
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        try {
            this.setCircuitState(b);
        }
        catch (Exception e) {
            throw new ParameterException((Throwable)e);
        }
        return b.length;
    }

    @Override
    public byte[] encode() throws ParameterException {
        return this.circuitState;
    }

    public byte[] getCircuitState() {
        return this.circuitState;
    }

    public void setCircuitState(byte[] circuitState) throws IllegalArgumentException {
        if (circuitState == null || circuitState.length == 0) {
            throw new IllegalArgumentException("byte[] must nto be null and length must be greater than 0");
        }
        this.circuitState = circuitState;
    }

    public byte createCircuitState(int MBS, int CPS, int HBS) {
        int v = 0;
        if (HBS != 0) {
            CPS = 3;
        }
        v = MBS & 3;
        v |= (CPS & 3) << 2;
        return (byte)(v |= (HBS & 3) << 4);
    }

    public int getCallProcessingState(byte b) {
        return b >> 2 & 3;
    }

    public int getHardwareBlockingState(byte b) {
        return b >> 4 & 3;
    }

    public int getMaintenanceBlockingState(byte b) {
        return b & 3;
    }

    public int getCode() {
        return 38;
    }
}

