/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.CircuitAssigmentMap;

public class CircuitAssigmentMapImpl
extends AbstractISUPParameter
implements CircuitAssigmentMap {
    private static final int _CIRCUIT_ENABLED = 1;
    private int mapType = 0;
    private int mapFormat = 0;

    public CircuitAssigmentMapImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public CircuitAssigmentMapImpl(int mapType, int mapFormat) {
        this.mapType = mapType;
        this.mapFormat = mapFormat;
    }

    public CircuitAssigmentMapImpl() {
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length != 5) {
            throw new ParameterException("byte[] must  not be null and length must  be 5");
        }
        this.mapType = b[0] & 0x3F;
        this.mapFormat = b[1];
        this.mapFormat |= b[2] << 8;
        this.mapFormat |= b[3] << 16;
        this.mapFormat |= (b[4] & 0x7F) << 24;
        return 5;
    }

    @Override
    public byte[] encode() throws ParameterException {
        byte[] b = new byte[]{(byte)(this.mapType & 0x3F), (byte)this.mapFormat, (byte)(this.mapFormat >> 8), (byte)(this.mapFormat >> 16), (byte)(this.mapFormat >> 24 & 0x7F)};
        return b;
    }

    public int getMapType() {
        return this.mapType;
    }

    public void setMapType(int mapType) {
        this.mapType = mapType;
    }

    public int getMapFormat() {
        return this.mapFormat;
    }

    public void setMapFormat(int mapFormat) {
        this.mapFormat = mapFormat;
    }

    public void enableCircuit(int circuitNumber) throws IllegalArgumentException {
        if (circuitNumber < 1 || circuitNumber > 31) {
            throw new IllegalArgumentException("Cicruit number is out of range[" + circuitNumber + "] <1,31>");
        }
        this.mapFormat |= 1 << circuitNumber - 1;
    }

    public void disableCircuit(int circuitNumber) throws IllegalArgumentException {
        if (circuitNumber < 1 || circuitNumber > 31) {
            throw new IllegalArgumentException("Cicruit number is out of range[" + circuitNumber + "] <1,31>");
        }
        this.mapFormat &= -2 << circuitNumber - 1;
    }

    public boolean isCircuitEnabled(int circuitNumber) throws IllegalArgumentException {
        if (circuitNumber < 1 || circuitNumber > 31) {
            throw new IllegalArgumentException("Cicruit number is out of range[" + circuitNumber + "] <1,31>");
        }
        return (this.mapFormat >> circuitNumber - 1 & 1) == 1;
    }

    public int getCode() {
        return 37;
    }
}

