/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ByteArrayContainer;
import org.mobicents.protocols.ss7.isup.message.parameter.CauseIndicators;

public class CauseIndicatorsImpl
extends AbstractISUPParameter
implements CauseIndicators {
    private static final String LOCATION = "location";
    private static final String CAUSE_VALUE = "causeValue";
    private static final String CODING_STANDARD = "codingStandard";
    private static final String RECOMMENDATION = "recommendation";
    private static final String DIAGNOSTICS = "diagnostics";
    private static final int DEFAULT_VALUE = 0;
    private int location = 0;
    private int causeValue = 0;
    private int codingStandard = 0;
    private int recommendation = 0;
    private byte[] diagnostics = null;
    protected static final XMLFormat<CauseIndicatorsImpl> ISUP_CAUSE_INDICATORS_XML = new XMLFormat<CauseIndicatorsImpl>(CauseIndicatorsImpl.class){

        public void read(XMLFormat.InputElement xml, CauseIndicatorsImpl causeIndicators) throws XMLStreamException {
            causeIndicators.location = xml.getAttribute(CauseIndicatorsImpl.LOCATION, 0);
            causeIndicators.causeValue = xml.getAttribute(CauseIndicatorsImpl.CAUSE_VALUE, 0);
            causeIndicators.codingStandard = xml.getAttribute(CauseIndicatorsImpl.CODING_STANDARD, 0);
            causeIndicators.recommendation = xml.getAttribute(CauseIndicatorsImpl.RECOMMENDATION, 0);
            ByteArrayContainer bc = (ByteArrayContainer)xml.get(CauseIndicatorsImpl.DIAGNOSTICS, ByteArrayContainer.class);
            if (bc != null) {
                CauseIndicatorsImpl.access$402(causeIndicators, bc.getData());
            }
        }

        public void write(CauseIndicatorsImpl causeIndicators, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(CauseIndicatorsImpl.LOCATION, causeIndicators.location);
            xml.setAttribute(CauseIndicatorsImpl.CAUSE_VALUE, causeIndicators.causeValue);
            xml.setAttribute(CauseIndicatorsImpl.CODING_STANDARD, causeIndicators.codingStandard);
            xml.setAttribute(CauseIndicatorsImpl.RECOMMENDATION, causeIndicators.recommendation);
            if (causeIndicators.diagnostics != null) {
                ByteArrayContainer bac = new ByteArrayContainer(causeIndicators.diagnostics);
                xml.add((Object)bac, CauseIndicatorsImpl.DIAGNOSTICS, ByteArrayContainer.class);
            }
        }
    };

    public CauseIndicatorsImpl() {
    }

    public CauseIndicatorsImpl(int codingStandard, int location, int recommendation, int causeValue, byte[] diagnostics) {
        this.setCodingStandard(codingStandard);
        this.setLocation(location);
        this.setRecommendation(recommendation);
        this.setCauseValue(causeValue);
        this.diagnostics = diagnostics;
    }

    @Override
    public int decode(byte[] b) throws ParameterException {
        if (b == null || b.length < 2) {
            throw new ParameterException("byte[] must not be null or has size less than 2");
        }
        int index = 0;
        int v = 0;
        v = b[index] & 0x7F;
        this.location = v & 0xF;
        this.codingStandard = v >> 5;
        index = (b[index] & 0x7F) >> 7 == 0 ? (index += 2) : ++index;
        v = 0;
        this.causeValue = v = b[1] & 0x7F;
        if (b.length == 2) {
            return 2;
        }
        if ((b.length - 2) % 3 != 0) {
            throw new ParameterException("Diagnostics part  must have 3xN bytes, it has: " + (b.length - 2));
        }
        int byteCounter = 2;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 2; i < b.length; ++i) {
            bos.write(b[i]);
            ++byteCounter;
        }
        this.diagnostics = bos.toByteArray();
        return byteCounter;
    }

    @Override
    public byte[] encode() throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int v = this.location & 0xF;
        bos.write(v |= (byte)((this.codingStandard & 3) << 5) | 0x80);
        bos.write(this.causeValue | 0x80);
        if (this.diagnostics != null) {
            try {
                bos.write(this.diagnostics);
            }
            catch (IOException e) {
                throw new ParameterException((Throwable)e);
            }
        }
        byte[] b = bos.toByteArray();
        return b;
    }

    @Override
    public int encode(ByteArrayOutputStream bos) throws ParameterException {
        byte[] b = this.encode();
        try {
            bos.write(b);
        }
        catch (IOException e) {
            throw new ParameterException((Throwable)e);
        }
        return b.length;
    }

    public int getCodingStandard() {
        return this.codingStandard;
    }

    public void setCodingStandard(int codingStandard) {
        this.codingStandard = codingStandard & 3;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location & 0xF;
    }

    public int getCauseValue() {
        return this.causeValue & 0x7F;
    }

    public int getRecommendation() {
        return this.recommendation;
    }

    public void setRecommendation(int recommendation) {
        this.recommendation = recommendation & 0x7F;
    }

    public void setCauseValue(int causeValue) {
        this.causeValue = causeValue;
    }

    public byte[] getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(byte[] diagnostics) {
        this.diagnostics = diagnostics;
    }

    public int getCode() {
        return 18;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CauseIndicators [");
        sb.append("codingStandard=");
        sb.append(this.codingStandard);
        sb.append(", location=");
        sb.append(this.location);
        sb.append(", recommendation=");
        sb.append(this.recommendation);
        sb.append(", causeValue=");
        sb.append(this.causeValue);
        if (this.diagnostics != null) {
            sb.append(", diagnostics=[");
            sb.append(this.printDataArr(this.diagnostics));
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    protected String printDataArr(byte[] data) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (data != null) {
            for (byte b : data) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(b);
            }
        }
        return sb.toString();
    }

    static /* synthetic */ byte[] access$402(CauseIndicatorsImpl x0, byte[] x1) {
        x0.diagnostics = x1;
        return x1;
    }
}

