/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.CallingPartyNumber;

public class CallingPartyNumberImpl
extends AbstractNAINumber
implements CallingPartyNumber {
    private static final String NUMBERING_PLAN_INDICATOR = "numberingPlanIndicator";
    private static final String NUMBER_NUMBER_INCOMPLETE_INDICATOR = "numberIncompleteIndicator";
    private static final String ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR = "addressRepresentationRestrictedIndicator";
    private static final String SCREENING_INDICATOR = "screeningIndicator";
    private static final int DEFAULT_NUMBERING_PLAN_INDICATOR = 0;
    private static final int DEFAULT_NUMBER_NUMBER_INCOMPLETE_INDICATOR = 0;
    private static final int DEFAULT_ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR = 0;
    private static final int DEFAULT_SCREENING_INDICATOR = 0;
    protected int numberingPlanIndicator;
    protected int numberIncompleteIndicator;
    protected int addressRepresentationRestrictedIndicator;
    protected int screeningIndicator;
    protected static final XMLFormat<CallingPartyNumberImpl> ISUP_CALLING_PARTY_NUMBER_XML = new XMLFormat<CallingPartyNumberImpl>(CallingPartyNumberImpl.class){

        public void read(XMLFormat.InputElement xml, CallingPartyNumberImpl callingPartyNumber) throws XMLStreamException {
            AbstractNAINumber.ISUP_ABSTRACT_NAI_NUMBER_XML.read(xml, (Object)callingPartyNumber);
            callingPartyNumber.numberingPlanIndicator = xml.getAttribute(CallingPartyNumberImpl.NUMBERING_PLAN_INDICATOR, 0);
            callingPartyNumber.numberIncompleteIndicator = xml.getAttribute(CallingPartyNumberImpl.NUMBER_NUMBER_INCOMPLETE_INDICATOR, 0);
            callingPartyNumber.addressRepresentationRestrictedIndicator = xml.getAttribute(CallingPartyNumberImpl.ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR, 0);
            callingPartyNumber.screeningIndicator = xml.getAttribute(CallingPartyNumberImpl.SCREENING_INDICATOR, 0);
        }

        public void write(CallingPartyNumberImpl callingPartyNumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            AbstractNAINumber.ISUP_ABSTRACT_NAI_NUMBER_XML.write((Object)callingPartyNumber, xml);
            xml.setAttribute(CallingPartyNumberImpl.NUMBERING_PLAN_INDICATOR, callingPartyNumber.numberingPlanIndicator);
            xml.setAttribute(CallingPartyNumberImpl.NUMBER_NUMBER_INCOMPLETE_INDICATOR, callingPartyNumber.numberIncompleteIndicator);
            xml.setAttribute(CallingPartyNumberImpl.ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR, callingPartyNumber.addressRepresentationRestrictedIndicator);
            xml.setAttribute(CallingPartyNumberImpl.SCREENING_INDICATOR, callingPartyNumber.screeningIndicator);
        }
    };

    public CallingPartyNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public CallingPartyNumberImpl() {
    }

    public CallingPartyNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public CallingPartyNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int numberIncompleteIndicator, int addressRepresentationREstrictedIndicator, int screeningIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.numberIncompleteIndicator = numberIncompleteIndicator;
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
        this.screeningIndicator = screeningIndicator;
    }

    @Override
    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.numberIncompleteIndicator = (b & 0x80) >> 7;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.addressRepresentationRestrictedIndicator = (b & 0xC) >> 2;
        this.screeningIndicator = b & 3;
        return 1;
    }

    @Override
    public int encodeHeader(ByteArrayOutputStream bos) {
        this.doAddressPresentationRestricted();
        return super.encodeHeader(bos);
    }

    @Override
    public int encodeBody(ByteArrayOutputStream bos) {
        int c = this.numberingPlanIndicator << 4;
        c |= this.numberIncompleteIndicator << 7;
        c |= this.addressRepresentationRestrictedIndicator << 2;
        bos.write(c |= this.screeningIndicator);
        return 1;
    }

    protected void doAddressPresentationRestricted() {
        if (this.addressRepresentationRestrictedIndicator == 2) {
            this.oddFlag = 0;
            this.natureOfAddresIndicator = 0;
            this.numberIncompleteIndicator = 0;
            this.numberingPlanIndicator = 0;
            this.screeningIndicator = 3;
            this.setAddress("");
        }
    }

    @Override
    public int decodeDigits(ByteArrayInputStream bis) throws ParameterException {
        if (this.addressRepresentationRestrictedIndicator == 2) {
            this.setAddress("");
            return 0;
        }
        return super.decodeDigits(bis);
    }

    @Override
    public int encodeDigits(ByteArrayOutputStream bos) {
        if (this.addressRepresentationRestrictedIndicator == 2) {
            return 0;
        }
        return super.encodeDigits(bos);
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getNumberIncompleteIndicator() {
        return this.numberIncompleteIndicator;
    }

    public void setNumberIncompleteIndicator(int numberIncompleteIndicator) {
        this.numberIncompleteIndicator = numberIncompleteIndicator;
    }

    public int getAddressRepresentationRestrictedIndicator() {
        return this.addressRepresentationRestrictedIndicator;
    }

    public void setAddressRepresentationREstrictedIndicator(int addressRepresentationREstrictedIndicator) {
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
    }

    public int getScreeningIndicator() {
        return this.screeningIndicator;
    }

    public void setScreeningIndicator(int screeningIndicator) {
        this.screeningIndicator = screeningIndicator;
    }

    public int getCode() {
        return 10;
    }

    public String toString() {
        return "CallingPartyNumber [numberingPlanIndicator=" + this.numberingPlanIndicator + ", numberIncompleteIndicator=" + this.numberIncompleteIndicator + ", addressRepresentationRestrictedIndicator=" + this.addressRepresentationRestrictedIndicator + ", screeningIndicator=" + this.screeningIndicator + ", natureOfAddresIndicator=" + this.natureOfAddresIndicator + ", oddFlag=" + this.oddFlag + ", address=" + this.address + "]";
    }
}

