/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.CalledPartyNumber;

public class CalledPartyNumberImpl
extends AbstractNAINumber
implements CalledPartyNumber {
    private static final String NUMBERING_PLAN_INDICATOR = "numberingPlanIndicator";
    private static final String INTERNAL_NETWORK_NUMBER_INDICATOR = "internalNetworkNumberIndicator";
    private static final int DEFAULT_NUMBERING_PLAN_INDICATOR = 0;
    private static final int DEFAULT_INTERNAL_NETWORK_NUMBER_INDICATOR = 0;
    protected int numberingPlanIndicator;
    protected int internalNetworkNumberIndicator;
    protected static final XMLFormat<CalledPartyNumberImpl> ISUP_CALLED_PARTY_NUMBER_XML = new XMLFormat<CalledPartyNumberImpl>(CalledPartyNumberImpl.class){

        public void read(XMLFormat.InputElement xml, CalledPartyNumberImpl calledPartyNumber) throws XMLStreamException {
            AbstractNAINumber.ISUP_ABSTRACT_NAI_NUMBER_XML.read(xml, (Object)calledPartyNumber);
            calledPartyNumber.numberingPlanIndicator = xml.getAttribute(CalledPartyNumberImpl.NUMBERING_PLAN_INDICATOR, 0);
            calledPartyNumber.internalNetworkNumberIndicator = xml.getAttribute(CalledPartyNumberImpl.INTERNAL_NETWORK_NUMBER_INDICATOR, 0);
        }

        public void write(CalledPartyNumberImpl calledPartyNumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            AbstractNAINumber.ISUP_ABSTRACT_NAI_NUMBER_XML.write((Object)calledPartyNumber, xml);
            xml.setAttribute(CalledPartyNumberImpl.NUMBERING_PLAN_INDICATOR, calledPartyNumber.numberingPlanIndicator);
            xml.setAttribute(CalledPartyNumberImpl.INTERNAL_NETWORK_NUMBER_INDICATOR, calledPartyNumber.internalNetworkNumberIndicator);
        }
    };

    public CalledPartyNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public CalledPartyNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public CalledPartyNumberImpl() {
    }

    public CalledPartyNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int internalNetworkNumberIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
    }

    @Override
    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.internalNetworkNumberIndicator = (b & 0x80) >> 7;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        return 1;
    }

    @Override
    public int encodeBody(ByteArrayOutputStream bos) {
        int c = (this.numberingPlanIndicator & 7) << 4;
        bos.write(c |= (this.internalNetworkNumberIndicator & 1) << 7);
        return 1;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getInternalNetworkNumberIndicator() {
        return this.internalNetworkNumberIndicator;
    }

    public void setInternalNetworkNumberIndicator(int internalNetworkNumberIndicator) {
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
    }

    public int getCode() {
        return 4;
    }

    public String toString() {
        return "CalledPartyNumber [numberingPlanIndicator=" + this.numberingPlanIndicator + ", internalNetworkNumberIndicator=" + this.internalNetworkNumberIndicator + ", natureOfAddresIndicator=" + this.natureOfAddresIndicator + ", oddFlag=" + this.oddFlag + ", address=" + this.address + "]";
    }
}

