/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.CalledNumber;

public abstract class CalledNumberImpl
extends AbstractNAINumber
implements CalledNumber {
    private static final String NUMBERING_PLAN_INDICATOR = "numberingPlanIndicator";
    private static final String ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR = "addressRepresentationRestrictedIndicator";
    private static final int DEFAULT_NUMBERING_PLAN_INDICATOR = 0;
    private static final int DEFAULT_ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR = 0;
    protected int numberingPlanIndicator;
    protected int addressRepresentationRestrictedIndicator;
    protected static final XMLFormat<CalledNumberImpl> ISUP_CALLED_NUMBER_XML = new XMLFormat<CalledNumberImpl>(CalledNumberImpl.class){

        public void read(XMLFormat.InputElement xml, CalledNumberImpl calledNumber) throws XMLStreamException {
            AbstractNAINumber.ISUP_ABSTRACT_NAI_NUMBER_XML.read(xml, (Object)calledNumber);
            calledNumber.numberingPlanIndicator = xml.getAttribute(CalledNumberImpl.NUMBERING_PLAN_INDICATOR, 0);
            calledNumber.addressRepresentationRestrictedIndicator = xml.getAttribute(CalledNumberImpl.ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR, 0);
        }

        public void write(CalledNumberImpl calledNumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            AbstractNAINumber.ISUP_ABSTRACT_NAI_NUMBER_XML.write((Object)calledNumber, xml);
            xml.setAttribute(CalledNumberImpl.NUMBERING_PLAN_INDICATOR, calledNumber.numberingPlanIndicator);
            xml.setAttribute(CalledNumberImpl.ADDRESS_REPRESENTATION_RESTRICTED_INDICATOR, calledNumber.addressRepresentationRestrictedIndicator);
        }
    };

    public CalledNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public CalledNumberImpl() {
    }

    public CalledNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public CalledNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int addressRepresentationREstrictedIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
    }

    @Override
    public int encodeHeader(ByteArrayOutputStream bos) {
        this.doAddressPresentationRestricted();
        return super.encodeHeader(bos);
    }

    @Override
    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.addressRepresentationRestrictedIndicator = (b & 0xC) >> 2;
        return 1;
    }

    protected void doAddressPresentationRestricted() {
        if (this.addressRepresentationRestrictedIndicator == 2) {
            this.oddFlag = 0;
            this.natureOfAddresIndicator = 0;
            this.numberingPlanIndicator = 0;
            this.setAddress("");
        }
    }

    @Override
    public int encodeBody(ByteArrayOutputStream bos) {
        int c = (this.numberingPlanIndicator & 7) << 4;
        bos.write(c |= (this.addressRepresentationRestrictedIndicator & 3) << 2);
        return 1;
    }

    @Override
    public int decodeDigits(ByteArrayInputStream bis) throws ParameterException {
        if (this.addressRepresentationRestrictedIndicator == 2) {
            this.setAddress("");
            return 0;
        }
        return super.decodeDigits(bis);
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getAddressRepresentationRestrictedIndicator() {
        return this.addressRepresentationRestrictedIndicator;
    }

    public void setAddressRepresentationRestrictedIndicator(int addressRepresentationREstrictedIndicator) {
        this.addressRepresentationRestrictedIndicator = addressRepresentationREstrictedIndicator;
    }

    protected abstract String getPrimitiveName();

    public String toString() {
        return this.getPrimitiveName() + " [numberingPlanIndicator=" + this.numberingPlanIndicator + ", addressRepresentationREstrictedIndicator=" + this.addressRepresentationRestrictedIndicator + ", natureOfAddresIndicator=" + this.natureOfAddresIndicator + ", oddFlag=" + this.oddFlag + ", address=" + this.address + "]";
    }
}

