/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.CalledDirectoryNumber;

public class CalledDirectoryNumberImpl
extends AbstractNAINumber
implements CalledDirectoryNumber {
    protected int numberingPlanIndicator;
    protected int internalNetworkNumberIndicator;

    public CalledDirectoryNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
        this.getNumberingPlanIndicator();
    }

    public CalledDirectoryNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public CalledDirectoryNumberImpl() {
    }

    public CalledDirectoryNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int internalNetworkNumberIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
    }

    @Override
    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        if (bis.available() == 0) {
            throw new IllegalArgumentException("No more data to read.");
        }
        int b = bis.read() & 0xFF;
        this.internalNetworkNumberIndicator = (b & 0x80) >> 7;
        this.numberingPlanIndicator = b >> 4 & 7;
        return 1;
    }

    @Override
    public int encodeBody(ByteArrayOutputStream bos) {
        int c = (this.numberingPlanIndicator & 7) << 4;
        bos.write(c |= this.internalNetworkNumberIndicator << 7);
        return 1;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getInternalNetworkNumberIndicator() {
        return this.internalNetworkNumberIndicator;
    }

    public void setInternalNetworkNumberIndicator(int internalNetworkNumberIndicator) {
        this.internalNetworkNumberIndicator = internalNetworkNumberIndicator;
    }

    public int getCode() {
        return 125;
    }
}

