/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractNAINumber;
import org.mobicents.protocols.ss7.isup.message.parameter.CallTransferNumber;

public class CallTransferNumberImpl
extends AbstractNAINumber
implements CallTransferNumber {
    protected int numberingPlanIndicator;
    protected int addressRepresentationREstrictedIndicator;
    protected int screeningIndicator;

    public CallTransferNumberImpl(byte[] representation) throws ParameterException {
        super(representation);
    }

    public CallTransferNumberImpl() {
    }

    public CallTransferNumberImpl(ByteArrayInputStream bis) throws ParameterException {
        super(bis);
    }

    public CallTransferNumberImpl(int natureOfAddresIndicator, String address, int numberingPlanIndicator, int addressRepresentationREstrictedIndicator, int screeningIndicator) {
        super(natureOfAddresIndicator, address);
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.addressRepresentationREstrictedIndicator = addressRepresentationREstrictedIndicator;
        this.screeningIndicator = screeningIndicator;
    }

    @Override
    public int encodeHeader(ByteArrayOutputStream bos) {
        this.doAddressPresentationRestricted();
        return super.encodeHeader(bos);
    }

    protected void doAddressPresentationRestricted() {
    }

    @Override
    public int decodeBody(ByteArrayInputStream bis) throws IllegalArgumentException {
        int b = bis.read() & 0xFF;
        this.numberingPlanIndicator = (b & 0x70) >> 4;
        this.addressRepresentationREstrictedIndicator = (b & 0xC) >> 2;
        this.screeningIndicator = b & 3;
        return 1;
    }

    @Override
    public int encodeBody(ByteArrayOutputStream bos) {
        int c = this.numberingPlanIndicator << 4;
        c |= this.addressRepresentationREstrictedIndicator << 2;
        bos.write((c |= this.screeningIndicator) & 0x7F);
        return 1;
    }

    public int getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public void setNumberingPlanIndicator(int numberingPlanIndicator) {
        this.numberingPlanIndicator = numberingPlanIndicator;
    }

    public int getAddressRepresentationRestrictedIndicator() {
        return this.addressRepresentationREstrictedIndicator;
    }

    public void setAddressRepresentationRestrictedIndicator(int addressRepresentationREstrictedIndicator) {
        this.addressRepresentationREstrictedIndicator = addressRepresentationREstrictedIndicator;
    }

    public int getScreeningIndicator() {
        return this.screeningIndicator;
    }

    public void setScreeningIndicator(int screeningIndicator) {
        this.screeningIndicator = screeningIndicator;
    }

    public int getCode() {
        return 69;
    }
}

