/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message;

import java.util.Map;
import java.util.Set;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.ISUPMessageImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.MessageTypeImpl;
import org.mobicents.protocols.ss7.isup.message.InformationMessage;
import org.mobicents.protocols.ss7.isup.message.parameter.CallReference;
import org.mobicents.protocols.ss7.isup.message.parameter.CallingPartyCategory;
import org.mobicents.protocols.ss7.isup.message.parameter.CallingPartyNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.ConnectionRequest;
import org.mobicents.protocols.ss7.isup.message.parameter.ISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.InformationIndicators;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageName;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageType;
import org.mobicents.protocols.ss7.isup.message.parameter.NetworkSpecificFacility;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInformation;

public class InformationMessageImpl
extends ISUPMessageImpl
implements InformationMessage {
    public static final MessageType _MESSAGE_TYPE = new MessageTypeImpl(MessageName.Information);
    static final int _INDEX_F_MessageType = 0;
    static final int _INDEX_F_InformationIndicators = 1;
    static final int _INDEX_O_CallingPartyCategory = 0;
    static final int _INDEX_O_CallingPartyNumber = 1;
    static final int _INDEX_O_CallReference = 2;
    static final int _INDEX_O_ConnectionRequest = 3;
    static final int _INDEX_O_ParameterCompatibilityInformation = 4;
    static final int _INDEX_O_NetworkSpecificFacility = 5;
    static final int _INDEX_O_EndOfOptionalParameters = 6;

    public InformationMessageImpl(Set<Integer> mandatoryCodes, Set<Integer> mandatoryVariableCodes, Set<Integer> optionalCodes, Map<Integer, Integer> mandatoryCode2Index, Map<Integer, Integer> mandatoryVariableCode2Index, Map<Integer, Integer> optionalCode2Index) {
        super(mandatoryCodes, mandatoryVariableCodes, optionalCodes, mandatoryCode2Index, mandatoryVariableCode2Index, optionalCode2Index);
        this.f_Parameters.put(0, (ISUPParameter)this.getMessageType());
        this.o_Parameters.put(6, _END_OF_OPTIONAL_PARAMETERS);
    }

    public InformationIndicators getInformationIndicators() {
        return (InformationIndicators)this.f_Parameters.get(1);
    }

    public void setInformationIndicators(InformationIndicators v) {
        this.f_Parameters.put(1, (ISUPParameter)v);
    }

    public CallingPartyCategory getCallingPartyCategory() {
        return (CallingPartyCategory)this.o_Parameters.get(0);
    }

    public void setCallingPartyCategory(CallingPartyCategory v) {
        this.o_Parameters.put(0, (ISUPParameter)v);
    }

    public CallingPartyNumber getCallingPartyNumber() {
        return (CallingPartyNumber)this.o_Parameters.get(1);
    }

    public void setCallingPartyNumber(CallingPartyNumber v) {
        this.o_Parameters.put(1, (ISUPParameter)v);
    }

    public CallReference getCallReference() {
        return (CallReference)this.o_Parameters.get(2);
    }

    public void setCallReference(CallReference v) {
        this.o_Parameters.put(2, (ISUPParameter)v);
    }

    public ParameterCompatibilityInformation getParameterCompatibilityInformation() {
        return (ParameterCompatibilityInformation)this.o_Parameters.get(4);
    }

    public void setParameterCompatibilityInformation(ParameterCompatibilityInformation v) {
        this.o_Parameters.put(4, (ISUPParameter)v);
    }

    public ConnectionRequest getConnectionRequest() {
        return (ConnectionRequest)this.o_Parameters.get(3);
    }

    public void setConnectionRequest(ConnectionRequest v) {
        this.o_Parameters.put(3, (ISUPParameter)v);
    }

    public NetworkSpecificFacility getNetworkSpecificFacility() {
        return (NetworkSpecificFacility)this.o_Parameters.get(5);
    }

    public void setNetworkSpecificFacility(NetworkSpecificFacility v) {
        this.o_Parameters.put(5, (ISUPParameter)v);
    }

    @Override
    protected int decodeMandatoryParameters(ISUPParameterFactory parameterFactory, byte[] b, int index) throws ParameterException {
        int localIndex = index;
        if (b.length - (index += super.decodeMandatoryParameters(parameterFactory, b, index)) > 1) {
            try {
                byte[] informationInd = new byte[]{b[index++], b[index++]};
                InformationIndicators bci = parameterFactory.createInformationIndicators();
                ((AbstractISUPParameter)bci).decode(informationInd);
                this.setInformationIndicators(bci);
            }
            catch (Exception e) {
                throw new ParameterException("Failed to parse BackwardCallIndicators due to: ", (Throwable)e);
            }
            return index - localIndex;
        }
        throw new IllegalArgumentException("byte[] must have atleast 2 octets");
    }

    @Override
    protected void decodeMandatoryVariableBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, int parameterIndex) throws ParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void decodeOptionalBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, byte parameterCode) throws ParameterException {
        switch (parameterCode & 0xFF) {
            case 9: {
                CallingPartyCategory RS = parameterFactory.createCallingPartyCategory();
                ((AbstractISUPParameter)RS).decode(parameterBody);
                this.setCallingPartyCategory(RS);
                break;
            }
            case 10: {
                CallingPartyNumber x = parameterFactory.createCallingPartyNumber();
                ((AbstractISUPParameter)x).decode(parameterBody);
                this.setCallingPartyNumber(x);
                break;
            }
            case 1: {
                CallReference cf = parameterFactory.createCallReference();
                ((AbstractISUPParameter)cf).decode(parameterBody);
                this.setCallReference(cf);
                break;
            }
            case 13: {
                ConnectionRequest z = parameterFactory.createConnectionRequest();
                ((AbstractISUPParameter)z).decode(parameterBody);
                this.setConnectionRequest(z);
                break;
            }
            case 57: {
                ParameterCompatibilityInformation cc = parameterFactory.createParameterCompatibilityInformation();
                ((AbstractISUPParameter)cc).decode(parameterBody);
                this.setParameterCompatibilityInformation(cc);
                break;
            }
            case 47: {
                NetworkSpecificFacility v = parameterFactory.createNetworkSpecificFacility();
                ((AbstractISUPParameter)v).decode(parameterBody);
                this.setNetworkSpecificFacility(v);
                break;
            }
            default: {
                throw new ParameterException("Unrecognized parameter code for optional part: " + parameterCode);
            }
        }
    }

    @Override
    public MessageType getMessageType() {
        return _MESSAGE_TYPE;
    }

    @Override
    protected int getNumberOfMandatoryVariableLengthParameters() {
        return 0;
    }

    @Override
    public boolean hasAllMandatoryParameters() {
        return this.getInformationIndicators() != null;
    }

    @Override
    protected boolean optionalPartIsPossible() {
        return true;
    }
}

