/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message;

import java.util.Map;
import java.util.Set;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.ISUPMessageImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.MessageTypeImpl;
import org.mobicents.protocols.ss7.isup.message.IdentificationResponseMessage;
import org.mobicents.protocols.ss7.isup.message.parameter.CallingPartyNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.ChargedPartyIdentification;
import org.mobicents.protocols.ss7.isup.message.parameter.GenericNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.ISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.MCIDResponseIndicators;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageCompatibilityInformation;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageName;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageType;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInformation;
import org.mobicents.protocols.ss7.isup.message.parameter.accessTransport.AccessTransport;

public class IdentificationResponseMessageImpl
extends ISUPMessageImpl
implements IdentificationResponseMessage {
    public static final MessageType _MESSAGE_TYPE = new MessageTypeImpl(MessageName.IdentificationResponse);
    private static final int _MANDATORY_VAR_COUNT = 0;
    private static final boolean _HAS_MANDATORY = true;
    private static final boolean _OPTIONAL_POSSIBLE = true;
    static final int _INDEX_F_MessageType = 0;
    static final int _INDEX_O_MCIDResponseIndicators = 0;
    static final int _INDEX_O_MessageCompatibilityInformation = 1;
    static final int _INDEX_O_ParameterCompatibilityInformation = 2;
    static final int _INDEX_O_CallingPartyNumber = 3;
    static final int _INDEX_O_AccessTransport = 4;
    static final int _INDEX_O_GenericNumber = 5;
    static final int _INDEX_O_ChargedPartyIdentification = 6;
    static final int _INDEX_O_EndOfOptionalParameters = 7;

    public IdentificationResponseMessageImpl(Set<Integer> mandatoryCodes, Set<Integer> mandatoryVariableCodes, Set<Integer> optionalCodes, Map<Integer, Integer> mandatoryCode2Index, Map<Integer, Integer> mandatoryVariableCode2Index, Map<Integer, Integer> optionalCode2Index) {
        super(mandatoryCodes, mandatoryVariableCodes, optionalCodes, mandatoryCode2Index, mandatoryVariableCode2Index, optionalCode2Index);
        this.f_Parameters.put(0, (ISUPParameter)this.getMessageType());
        this.o_Parameters.put(7, _END_OF_OPTIONAL_PARAMETERS);
    }

    @Override
    protected void decodeMandatoryVariableBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, int parameterIndex) throws ParameterException {
    }

    @Override
    protected void decodeOptionalBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, byte parameterCode) throws ParameterException {
        switch (parameterCode & 0xFF) {
            case 56: {
                MessageCompatibilityInformation mci = parameterFactory.createMessageCompatibilityInformation();
                ((AbstractISUPParameter)mci).decode(parameterBody);
                this.setMessageCompatibilityInformation(mci);
                break;
            }
            case 57: {
                ParameterCompatibilityInformation pci = parameterFactory.createParameterCompatibilityInformation();
                ((AbstractISUPParameter)pci).decode(parameterBody);
                this.setParameterCompatibilityInformation(pci);
                break;
            }
            case 60: {
                MCIDResponseIndicators ro = parameterFactory.createMCIDResponseIndicators();
                ((AbstractISUPParameter)ro).decode(parameterBody);
                this.setMCIDResponseIndicators(ro);
                break;
            }
            case 10: {
                CallingPartyNumber cpn = parameterFactory.createCallingPartyNumber();
                ((AbstractISUPParameter)cpn).decode(parameterBody);
                this.setCallingPartyNumber(cpn);
                break;
            }
            case 3: {
                AccessTransport at = parameterFactory.createAccessTransport();
                ((AbstractISUPParameter)at).decode(parameterBody);
                this.setAccessTransport(at);
                break;
            }
            case 192: {
                GenericNumber gn = parameterFactory.createGenericNumber();
                ((AbstractISUPParameter)gn).decode(parameterBody);
                this.setGenericNumber(gn);
                break;
            }
            case -1: {
                ChargedPartyIdentification cpi = parameterFactory.createChargedPartyIdentification();
                ((AbstractISUPParameter)cpi).decode(parameterBody);
                this.setChargedPartyIdentification(cpi);
                break;
            }
            default: {
                throw new ParameterException("Unrecognized parameter code for optional part: " + parameterCode);
            }
        }
    }

    @Override
    public MessageType getMessageType() {
        return _MESSAGE_TYPE;
    }

    @Override
    protected int getNumberOfMandatoryVariableLengthParameters() {
        return 0;
    }

    @Override
    public boolean hasAllMandatoryParameters() {
        return true;
    }

    @Override
    protected boolean optionalPartIsPossible() {
        return true;
    }

    public void setMCIDResponseIndicators(MCIDResponseIndicators mcid) {
        this.o_Parameters.put(0, (ISUPParameter)mcid);
    }

    public MCIDResponseIndicators getMCIDResponseIndicators() {
        return (MCIDResponseIndicators)this.o_Parameters.get(0);
    }

    public void setMessageCompatibilityInformation(MessageCompatibilityInformation mci) {
        this.o_Parameters.put(1, (ISUPParameter)mci);
    }

    public MessageCompatibilityInformation getMessageCompatibilityInformation() {
        return (MessageCompatibilityInformation)this.o_Parameters.get(1);
    }

    public void setParameterCompatibilityInformation(ParameterCompatibilityInformation pci) {
        this.o_Parameters.put(2, (ISUPParameter)pci);
    }

    public ParameterCompatibilityInformation getParameterCompatibilityInformation() {
        return (ParameterCompatibilityInformation)this.o_Parameters.get(2);
    }

    public void setCallingPartyNumber(CallingPartyNumber cpn) {
        this.o_Parameters.put(3, (ISUPParameter)cpn);
    }

    public CallingPartyNumber getCallingPartyNumber() {
        return (CallingPartyNumber)this.o_Parameters.get(3);
    }

    public void setAccessTransport(AccessTransport at) {
        this.o_Parameters.put(4, (ISUPParameter)at);
    }

    public AccessTransport getAccessTransport() {
        return (AccessTransport)this.o_Parameters.get(4);
    }

    public void setGenericNumber(GenericNumber gn) {
        this.o_Parameters.put(5, (ISUPParameter)gn);
    }

    public GenericNumber getGenericNumber() {
        return (GenericNumber)this.o_Parameters.get(5);
    }

    public void setChargedPartyIdentification(ChargedPartyIdentification cpi) {
        this.o_Parameters.put(6, (ISUPParameter)cpi);
    }

    public ChargedPartyIdentification getChargedPartyIdentification() {
        return (ChargedPartyIdentification)this.o_Parameters.get(6);
    }
}

