/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message;

import java.util.Map;
import java.util.Set;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.ISUPMessageImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.MessageTypeImpl;
import org.mobicents.protocols.ss7.isup.message.FacilityRejectedMessage;
import org.mobicents.protocols.ss7.isup.message.parameter.CauseIndicators;
import org.mobicents.protocols.ss7.isup.message.parameter.FacilityIndicator;
import org.mobicents.protocols.ss7.isup.message.parameter.ISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageName;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageType;
import org.mobicents.protocols.ss7.isup.message.parameter.UserToUserIndicators;

public class FacilityRejectedMessageImpl
extends ISUPMessageImpl
implements FacilityRejectedMessage {
    public static final MessageType _MESSAGE_TYPE = new MessageTypeImpl(MessageName.FacilityRejected);
    private static final int _MANDATORY_VAR_COUNT = 1;
    private static final boolean _OPTIONAL_POSSIBLE = true;
    static final int _INDEX_F_MessageType = 0;
    static final int _INDEX_F_FacilityIndicator = 1;
    static final int _INDEX_V_CauseIndicators = 0;
    static final int _INDEX_O_UserToUserIndicators = 0;
    static final int _INDEX_O_EndOfOptionalParameters = 4;

    public FacilityRejectedMessageImpl(Set<Integer> mandatoryCodes, Set<Integer> mandatoryVariableCodes, Set<Integer> optionalCodes, Map<Integer, Integer> mandatoryCode2Index, Map<Integer, Integer> mandatoryVariableCode2Index, Map<Integer, Integer> optionalCode2Index) {
        super(mandatoryCodes, mandatoryVariableCodes, optionalCodes, mandatoryCode2Index, mandatoryVariableCode2Index, optionalCode2Index);
        this.f_Parameters.put(0, (ISUPParameter)this.getMessageType());
        this.o_Parameters.put(4, _END_OF_OPTIONAL_PARAMETERS);
    }

    @Override
    protected int decodeMandatoryParameters(ISUPParameterFactory parameterFactory, byte[] b, int index) throws ParameterException {
        int localIndex = index;
        if (b.length - (index += super.decodeMandatoryParameters(parameterFactory, b, index)) > 1) {
            try {
                byte[] facilityIndicator = new byte[]{b[index++]};
                FacilityIndicator bci = parameterFactory.createFacilityIndicator();
                ((AbstractISUPParameter)bci).decode(facilityIndicator);
                this.setFacilityIndicator(bci);
            }
            catch (Exception e) {
                throw new ParameterException("Failed to parse BackwardCallIndicators due to: ", (Throwable)e);
            }
            return index - localIndex;
        }
        throw new IllegalArgumentException("byte[] must have atleast four octets");
    }

    @Override
    protected void decodeMandatoryVariableBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, int parameterIndex) throws ParameterException {
        switch (parameterIndex) {
            case 0: {
                CauseIndicators ras = parameterFactory.createCauseIndicators();
                ((AbstractISUPParameter)ras).decode(parameterBody);
                this.setCauseIndicators(ras);
                break;
            }
            default: {
                throw new ParameterException("Unrecognized parameter index for mandatory variable part, index: " + parameterIndex);
            }
        }
    }

    @Override
    protected void decodeOptionalBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, byte parameterCode) throws ParameterException {
        switch (parameterCode & 0xFF) {
            case 42: {
                UserToUserIndicators u2ui = parameterFactory.createUserToUserIndicators();
                ((AbstractISUPParameter)u2ui).decode(parameterBody);
                this.setUserToUserIndicators(u2ui);
                break;
            }
            default: {
                throw new ParameterException("Unrecognized parameter code for optional part: " + parameterCode);
            }
        }
    }

    @Override
    public MessageType getMessageType() {
        return _MESSAGE_TYPE;
    }

    @Override
    protected int getNumberOfMandatoryVariableLengthParameters() {
        return 1;
    }

    @Override
    public boolean hasAllMandatoryParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean optionalPartIsPossible() {
        return true;
    }

    public void setFacilityIndicator(FacilityIndicator fi) {
        this.f_Parameters.put(1, (ISUPParameter)fi);
    }

    public FacilityIndicator getFacilityIndicator() {
        return (FacilityIndicator)this.f_Parameters.get(1);
    }

    public void setCauseIndicators(CauseIndicators ci) {
        this.v_Parameters.put(0, (ISUPParameter)ci);
    }

    public CauseIndicators getCauseIndicators() {
        return (CauseIndicators)this.v_Parameters.get(0);
    }

    public void setUserToUserIndicators(UserToUserIndicators u2ui) {
        this.o_Parameters.put(4, (ISUPParameter)u2ui);
    }

    public UserToUserIndicators getUserToUserIndicators() {
        return (UserToUserIndicators)this.o_Parameters.get(4);
    }
}

