/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message;

import java.util.Map;
import java.util.Set;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.ISUPMessageImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.MessageTypeImpl;
import org.mobicents.protocols.ss7.isup.message.FacilityMessage;
import org.mobicents.protocols.ss7.isup.message.parameter.CallTransferNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.GenericNotificationIndicator;
import org.mobicents.protocols.ss7.isup.message.parameter.ISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageCompatibilityInformation;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageName;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageType;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInformation;
import org.mobicents.protocols.ss7.isup.message.parameter.PivotCounter;
import org.mobicents.protocols.ss7.isup.message.parameter.PivotRoutingBackwardInformation;
import org.mobicents.protocols.ss7.isup.message.parameter.PivotRoutingIndicators;
import org.mobicents.protocols.ss7.isup.message.parameter.PivotStatus;
import org.mobicents.protocols.ss7.isup.message.parameter.RedirectStatus;
import org.mobicents.protocols.ss7.isup.message.parameter.RedirectionNumber;
import org.mobicents.protocols.ss7.isup.message.parameter.RemoteOperations;
import org.mobicents.protocols.ss7.isup.message.parameter.ServiceActivation;
import org.mobicents.protocols.ss7.isup.message.parameter.accessTransport.AccessTransport;

public class FacilityMessageImpl
extends ISUPMessageImpl
implements FacilityMessage {
    public static final MessageType _MESSAGE_TYPE = new MessageTypeImpl(MessageName.Facility);
    private static final int _MANDATORY_VAR_COUNT = 0;
    private static final boolean _HAS_MANDATORY = true;
    private static final boolean _OPTIONAL_POSSIBLE = true;
    static final int _INDEX_F_MessageType = 0;
    static final int _INDEX_O_MessageCompatibilityInformation = 0;
    static final int _INDEX_O_ParameterCompatibilityInformation = 1;
    static final int _INDEX_O_RemoteOperations = 2;
    static final int _INDEX_O_ServiceActivation = 3;
    static final int _INDEX_O_CallTransferNumber = 4;
    static final int _INDEX_O_AccessTransport = 5;
    static final int _INDEX_O_GenericNotificationIndicator = 6;
    static final int _INDEX_O_RedirectionNumber = 7;
    static final int _INDEX_O_PivotRoutingIndicators = 8;
    static final int _INDEX_O_PivotStatus = 9;
    static final int _INDEX_O_PivotCounter = 10;
    static final int _INDEX_O_PivotRoutingBackwardInformation = 11;
    static final int _INDEX_O_RedirectStatus = 12;
    static final int _INDEX_O_EndOfOptionalParameters = 13;

    FacilityMessageImpl(Set<Integer> mandatoryCodes, Set<Integer> mandatoryVariableCodes, Set<Integer> optionalCodes, Map<Integer, Integer> mandatoryCode2Index, Map<Integer, Integer> mandatoryVariableCode2Index, Map<Integer, Integer> optionalCode2Index) {
        super(mandatoryCodes, mandatoryVariableCodes, optionalCodes, mandatoryCode2Index, mandatoryVariableCode2Index, optionalCode2Index);
        this.f_Parameters.put(0, (ISUPParameter)this.getMessageType());
        this.o_Parameters.put(13, _END_OF_OPTIONAL_PARAMETERS);
    }

    @Override
    protected void decodeMandatoryVariableBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, int parameterIndex) throws ParameterException {
    }

    @Override
    protected void decodeOptionalBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, byte parameterCode) throws ParameterException {
        switch (parameterCode & 0xFF) {
            case 56: {
                MessageCompatibilityInformation mci = parameterFactory.createMessageCompatibilityInformation();
                ((AbstractISUPParameter)mci).decode(parameterBody);
                this.setMessageCompatibilityInformation(mci);
                break;
            }
            case 57: {
                ParameterCompatibilityInformation pci = parameterFactory.createParameterCompatibilityInformation();
                ((AbstractISUPParameter)pci).decode(parameterBody);
                this.setParameterCompatibilityInformation(pci);
                break;
            }
            case 50: {
                RemoteOperations ro = parameterFactory.createRemoteOperations();
                ((AbstractISUPParameter)ro).decode(parameterBody);
                this.setRemoteOperations(ro);
                break;
            }
            case 51: {
                ServiceActivation sa = parameterFactory.createServiceActivation();
                ((AbstractISUPParameter)sa).decode(parameterBody);
                this.setServiceActivation(sa);
                break;
            }
            case 69: {
                CallTransferNumber ctn = parameterFactory.createCallTransferNumber();
                ((AbstractISUPParameter)ctn).decode(parameterBody);
                this.setCallTransferNumber(ctn);
                break;
            }
            case 3: {
                AccessTransport at = parameterFactory.createAccessTransport();
                ((AbstractISUPParameter)at).decode(parameterBody);
                this.setAccessTransport(at);
                break;
            }
            case 44: {
                GenericNotificationIndicator gni = parameterFactory.createGenericNotificationIndicator();
                ((AbstractISUPParameter)gni).decode(parameterBody);
                this.setGenericNotificationIndicator(gni);
                break;
            }
            case 12: {
                RedirectionNumber rn = parameterFactory.createRedirectionNumber();
                ((AbstractISUPParameter)rn).decode(parameterBody);
                this.setRedirectionNumber(rn);
                break;
            }
            case 124: {
                PivotRoutingIndicators pri = parameterFactory.createPivotRoutingIndicators();
                ((AbstractISUPParameter)pri).decode(parameterBody);
                this.setPivotRoutingIndicators(pri);
                break;
            }
            case 134: {
                PivotStatus ps = parameterFactory.createPivotStatus();
                ((AbstractISUPParameter)ps).decode(parameterBody);
                this.setPivotStatus(ps);
                break;
            }
            case 135: {
                PivotCounter pc = parameterFactory.createPivotCounter();
                ((AbstractISUPParameter)pc).decode(parameterBody);
                this.setPivotCounter(pc);
                break;
            }
            case 137: {
                PivotRoutingBackwardInformation prbi = parameterFactory.createPivotRoutingBackwardInformation();
                ((AbstractISUPParameter)prbi).decode(parameterBody);
                this.setPivotRoutingBackwardInformation(prbi);
                break;
            }
            case 138: {
                RedirectStatus u2ui = parameterFactory.createRedirectStatus();
                ((AbstractISUPParameter)u2ui).decode(parameterBody);
                this.setRedirectStatus(u2ui);
                break;
            }
            default: {
                throw new ParameterException("Unrecognized parameter code for optional part: " + parameterCode);
            }
        }
    }

    @Override
    public MessageType getMessageType() {
        return _MESSAGE_TYPE;
    }

    @Override
    protected int getNumberOfMandatoryVariableLengthParameters() {
        return 0;
    }

    @Override
    public boolean hasAllMandatoryParameters() {
        return true;
    }

    @Override
    protected boolean optionalPartIsPossible() {
        return true;
    }

    public void setMessageCompatibilityInformation(MessageCompatibilityInformation mci) {
        this.o_Parameters.put(0, (ISUPParameter)mci);
    }

    public MessageCompatibilityInformation getMessageCompatibilityInformation() {
        return (MessageCompatibilityInformation)this.o_Parameters.get(0);
    }

    public void setParameterCompatibilityInformation(ParameterCompatibilityInformation pci) {
        this.o_Parameters.put(1, (ISUPParameter)pci);
    }

    public ParameterCompatibilityInformation getParameterCompatibilityInformation() {
        return (ParameterCompatibilityInformation)this.o_Parameters.get(1);
    }

    public void setRemoteOperations(RemoteOperations ro) {
        this.o_Parameters.put(2, (ISUPParameter)ro);
    }

    public RemoteOperations getRemoteOperations() {
        return (RemoteOperations)this.o_Parameters.get(2);
    }

    public void setServiceActivation(ServiceActivation sa) {
        this.o_Parameters.put(3, (ISUPParameter)sa);
    }

    public ServiceActivation getServiceActivation() {
        return (ServiceActivation)this.o_Parameters.get(3);
    }

    public void setCallTransferNumber(CallTransferNumber ctn) {
        this.o_Parameters.put(4, (ISUPParameter)ctn);
    }

    public CallTransferNumber getCallTransferNumber() {
        return (CallTransferNumber)this.o_Parameters.get(4);
    }

    public void setAccessTransport(AccessTransport at) {
        this.o_Parameters.put(5, (ISUPParameter)at);
    }

    public AccessTransport getAccessTransport() {
        return (AccessTransport)this.o_Parameters.get(5);
    }

    public void setGenericNotificationIndicator(GenericNotificationIndicator gni) {
        this.o_Parameters.put(6, (ISUPParameter)gni);
    }

    public GenericNotificationIndicator getGenericNotificationIndicator() {
        return (GenericNotificationIndicator)this.o_Parameters.get(6);
    }

    public void setRedirectionNumber(RedirectionNumber rn) {
        this.o_Parameters.put(7, (ISUPParameter)rn);
    }

    public RedirectionNumber getRedirectionNumber() {
        return (RedirectionNumber)this.o_Parameters.get(7);
    }

    public void setPivotRoutingIndicators(PivotRoutingIndicators pri) {
        this.o_Parameters.put(8, (ISUPParameter)pri);
    }

    public PivotRoutingIndicators getPivotRoutingIndicators() {
        return (PivotRoutingIndicators)this.o_Parameters.get(8);
    }

    public void setPivotStatus(PivotStatus ps) {
        this.o_Parameters.put(9, (ISUPParameter)ps);
    }

    public PivotStatus getPivotStatus() {
        return (PivotStatus)this.o_Parameters.get(9);
    }

    public void setPivotCounter(PivotCounter pc) {
        this.o_Parameters.put(10, (ISUPParameter)pc);
    }

    public PivotCounter getPivotCounter() {
        return (PivotCounter)this.o_Parameters.get(10);
    }

    public void setPivotRoutingBackwardInformation(PivotRoutingBackwardInformation prbi) {
        this.o_Parameters.put(11, (ISUPParameter)prbi);
    }

    public PivotRoutingBackwardInformation getPivotRoutingBackwardInformation() {
        return (PivotRoutingBackwardInformation)this.o_Parameters.get(11);
    }

    public void setRedirectStatus(RedirectStatus rs) {
        this.o_Parameters.put(12, (ISUPParameter)rs);
    }

    public RedirectStatus getRedirectStatus() {
        return (RedirectStatus)this.o_Parameters.get(12);
    }
}

