/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message;

import java.util.Map;
import java.util.Set;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.ISUPMessageImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.MessageTypeImpl;
import org.mobicents.protocols.ss7.isup.message.ApplicationTransportMessage;
import org.mobicents.protocols.ss7.isup.message.parameter.ApplicationTransport;
import org.mobicents.protocols.ss7.isup.message.parameter.ISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageCompatibilityInformation;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageName;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageType;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInformation;

public class ApplicationTransportMessageImpl
extends ISUPMessageImpl
implements ApplicationTransportMessage {
    private static final int _MANDATORY_VAR_COUNT = 0;
    static final int _INDEX_F_MessageType = 0;
    static final int _INDEX_O_MessageCompatibilityInformation = 0;
    static final int _INDEX_O_ParameterCompatibilityInformation = 1;
    static final int _INDEX_O_ApplicationTransportParameter = 2;
    static final int _INDEX_O_EndOfOptionalParameters = 3;
    public static final MessageType _MESSAGE_TYPE = new MessageTypeImpl(MessageName.ApplicationTransport);

    public ApplicationTransportMessageImpl(Set<Integer> mandatoryCodes, Set<Integer> mandatoryVariableCodes, Set<Integer> optionalCodes, Map<Integer, Integer> mandatoryCode2Index, Map<Integer, Integer> mandatoryVariableCode2Index, Map<Integer, Integer> optionalCode2Index) {
        super(mandatoryCodes, mandatoryVariableCodes, optionalCodes, mandatoryCode2Index, mandatoryVariableCode2Index, optionalCode2Index);
        this.f_Parameters.put(0, (ISUPParameter)this.getMessageType());
        this.o_Parameters.put(3, _END_OF_OPTIONAL_PARAMETERS);
    }

    @Override
    protected void decodeMandatoryVariableBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, int parameterIndex) throws ParameterException {
    }

    @Override
    protected void decodeOptionalBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, byte parameterCode) throws ParameterException {
        switch (parameterCode & 0xFF) {
            case 56: {
                MessageCompatibilityInformation mci = parameterFactory.createMessageCompatibilityInformation();
                ((AbstractISUPParameter)mci).decode(parameterBody);
                this.setMessageCompatibilityInformation(mci);
                break;
            }
            case 57: {
                ParameterCompatibilityInformation pci = parameterFactory.createParameterCompatibilityInformation();
                ((AbstractISUPParameter)pci).decode(parameterBody);
                this.setParameterCompatibilityInformation(pci);
                break;
            }
            case 120: {
                ApplicationTransport apt = parameterFactory.createApplicationTransport();
                ((AbstractISUPParameter)apt).decode(parameterBody);
                this.setApplicationTransport(apt);
                break;
            }
            default: {
                throw new ParameterException("Unrecognized parameter code for optional part: " + parameterCode);
            }
        }
    }

    @Override
    public MessageType getMessageType() {
        return _MESSAGE_TYPE;
    }

    @Override
    protected int getNumberOfMandatoryVariableLengthParameters() {
        return 0;
    }

    @Override
    public boolean hasAllMandatoryParameters() {
        return true;
    }

    @Override
    protected boolean optionalPartIsPossible() {
        return true;
    }

    public void setMessageCompatibilityInformation(MessageCompatibilityInformation mci) {
        this.o_Parameters.put(0, (ISUPParameter)mci);
    }

    public MessageCompatibilityInformation getMessageCompatibilityInformation() {
        return (MessageCompatibilityInformation)this.o_Parameters.get(0);
    }

    public void setParameterCompatibilityInformation(ParameterCompatibilityInformation pci) {
        this.o_Parameters.put(1, (ISUPParameter)pci);
    }

    public ParameterCompatibilityInformation getParameterCompatibilityInformation() {
        return (ParameterCompatibilityInformation)this.o_Parameters.get(1);
    }

    public void setApplicationTransport(ApplicationTransport atp) {
        this.o_Parameters.put(2, (ISUPParameter)atp);
    }

    public ApplicationTransport getApplicationTransport() {
        return (ApplicationTransport)this.o_Parameters.get(2);
    }
}

