/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message;

import java.util.Map;
import java.util.Set;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.ISUPMessageImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.AbstractFacilityMessage;
import org.mobicents.protocols.ss7.isup.message.parameter.CallReference;
import org.mobicents.protocols.ss7.isup.message.parameter.ConnectionRequest;
import org.mobicents.protocols.ss7.isup.message.parameter.FacilityIndicator;
import org.mobicents.protocols.ss7.isup.message.parameter.ISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.ParameterCompatibilityInformation;
import org.mobicents.protocols.ss7.isup.message.parameter.UserToUserIndicators;

public abstract class AbstractFacilityMessageImpl
extends ISUPMessageImpl
implements AbstractFacilityMessage {
    private static final int _MANDATORY_VAR_COUNT = 0;
    private static final boolean _OPTIONAL_POSSIBLE = true;
    static final int _INDEX_F_MessageType = 0;
    static final int _INDEX_F_FacilityIndicator = 1;
    static final int _INDEX_O_UserToUserIndicators = 0;
    static final int _INDEX_O_CallReference = 1;
    static final int _INDEX_O_ConnectionRequest = 2;
    static final int _INDEX_O_ParameterCompatibilityInformation = 3;
    static final int _INDEX_O_EndOfOptionalParameters = 4;

    AbstractFacilityMessageImpl(Set<Integer> mandatoryCodes, Set<Integer> mandatoryVariableCodes, Set<Integer> optionalCodes, Map<Integer, Integer> mandatoryCode2Index, Map<Integer, Integer> mandatoryVariableCode2Index, Map<Integer, Integer> optionalCode2Index) {
        super(mandatoryCodes, mandatoryVariableCodes, optionalCodes, mandatoryCode2Index, mandatoryVariableCode2Index, optionalCode2Index);
        this.f_Parameters.put(0, (ISUPParameter)this.getMessageType());
        this.o_Parameters.put(4, _END_OF_OPTIONAL_PARAMETERS);
    }

    @Override
    public boolean hasAllMandatoryParameters() {
        if (this.f_Parameters.get(0) == null) {
            return false;
        }
        return this.f_Parameters.get(1) != null;
    }

    @Override
    protected int decodeMandatoryParameters(ISUPParameterFactory parameterFactory, byte[] b, int index) throws ParameterException {
        int localIndex = index;
        if (b.length - (index += super.decodeMandatoryParameters(parameterFactory, b, index)) > 1) {
            try {
                byte[] facilityIndicator = new byte[]{b[index++]};
                FacilityIndicator bci = parameterFactory.createFacilityIndicator();
                ((AbstractISUPParameter)bci).decode(facilityIndicator);
                this.setFacilityIndicator(bci);
            }
            catch (Exception e) {
                throw new ParameterException("Failed to parse BackwardCallIndicators due to: ", (Throwable)e);
            }
            return index - localIndex;
        }
        throw new IllegalArgumentException("byte[] must have atleast four octets");
    }

    @Override
    protected void decodeMandatoryVariableBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, int parameterIndex) throws ParameterException {
    }

    @Override
    protected void decodeOptionalBody(ISUPParameterFactory parameterFactory, byte[] parameterBody, byte parameterCode) throws ParameterException {
        switch (parameterCode & 0xFF) {
            case 42: {
                UserToUserIndicators u2ui = parameterFactory.createUserToUserIndicators();
                ((AbstractISUPParameter)u2ui).decode(parameterBody);
                this.setUserToUserIndicators(u2ui);
                break;
            }
            case 1: {
                CallReference cr = parameterFactory.createCallReference();
                ((AbstractISUPParameter)cr).decode(parameterBody);
                this.setCallReference(cr);
                break;
            }
            case 13: {
                ConnectionRequest conr = parameterFactory.createConnectionRequest();
                ((AbstractISUPParameter)conr).decode(parameterBody);
                this.setConnectionRequest(conr);
                break;
            }
            case 57: {
                ParameterCompatibilityInformation pci = parameterFactory.createParameterCompatibilityInformation();
                ((AbstractISUPParameter)pci).decode(parameterBody);
                this.setParameterCompatibilityInformation(pci);
                break;
            }
            default: {
                throw new ParameterException("Unrecognized parameter code for optional part: " + parameterCode);
            }
        }
    }

    @Override
    protected int getNumberOfMandatoryVariableLengthParameters() {
        return 0;
    }

    @Override
    protected boolean optionalPartIsPossible() {
        return true;
    }

    public void setFacilityIndicator(FacilityIndicator fi) {
        this.f_Parameters.put(1, (ISUPParameter)fi);
    }

    public FacilityIndicator getFacilityIndicator() {
        return (FacilityIndicator)this.f_Parameters.get(1);
    }

    public void setUserToUserIndicators(UserToUserIndicators u2ui) {
        this.o_Parameters.put(0, (ISUPParameter)u2ui);
    }

    public UserToUserIndicators getUserToUserIndicators() {
        return (UserToUserIndicators)this.o_Parameters.get(0);
    }

    public void setCallReference(CallReference cf) {
        this.o_Parameters.put(1, (ISUPParameter)cf);
    }

    public CallReference getCallReference() {
        return (CallReference)this.o_Parameters.get(1);
    }

    public void setConnectionRequest(ConnectionRequest cr) {
        this.o_Parameters.put(2, (ISUPParameter)cr);
    }

    public ConnectionRequest getConnectionRequest() {
        return (ConnectionRequest)this.o_Parameters.get(2);
    }

    public void setParameterCompatibilityInformation(ParameterCompatibilityInformation pci) {
        this.o_Parameters.put(3, (ISUPParameter)pci);
    }

    public ParameterCompatibilityInformation getCompatibilityInformation() {
        return (ParameterCompatibilityInformation)this.o_Parameters.get(3);
    }
}

