/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.inap.primitives;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.inap.api.INAPException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.inap.api.primitives.MiscCallInfo;
import org.mobicents.protocols.ss7.inap.api.primitives.MiscCallInfoDpAssignment;
import org.mobicents.protocols.ss7.inap.api.primitives.MiscCallInfoMessageType;
import org.mobicents.protocols.ss7.inap.primitives.INAPAsnPrimitive;

public class MiscCallInfoImpl
implements MiscCallInfo,
INAPAsnPrimitive {
    private static final String MESSAGE_TYPE = "messageType";
    private static final String DP_ASSIGNMENT = "dpAssignment";
    public static final int _ID_messageType = 0;
    public static final int _ID_dpAssignment = 1;
    public static final String _PrimitiveName = "MiscCallInfo";
    private MiscCallInfoMessageType messageType;
    private MiscCallInfoDpAssignment dpAssignment;
    protected static final XMLFormat<MiscCallInfoImpl> MISC_CALL_INFO_XML = new XMLFormat<MiscCallInfoImpl>(MiscCallInfoImpl.class){

        public void read(XMLFormat.InputElement xml, MiscCallInfoImpl miscCallInfo) throws XMLStreamException {
            Integer integ = (Integer)xml.get(MiscCallInfoImpl.MESSAGE_TYPE, Integer.class);
            if (integ != null) {
                miscCallInfo.messageType = MiscCallInfoMessageType.getInstance((int)integ);
            }
            if ((integ = (Integer)xml.get(MiscCallInfoImpl.DP_ASSIGNMENT, Integer.class)) != null) {
                miscCallInfo.dpAssignment = MiscCallInfoDpAssignment.getInstance((int)integ);
            }
        }

        public void write(MiscCallInfoImpl miscCallInfo, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (miscCallInfo.messageType != null) {
                xml.add((Object)miscCallInfo.messageType.getCode(), MiscCallInfoImpl.MESSAGE_TYPE, Integer.class);
            }
            if (miscCallInfo.dpAssignment != null) {
                xml.add((Object)miscCallInfo.dpAssignment.getCode(), MiscCallInfoImpl.DP_ASSIGNMENT, Integer.class);
            }
        }
    };

    public MiscCallInfoImpl() {
    }

    public MiscCallInfoImpl(MiscCallInfoMessageType messageType, MiscCallInfoDpAssignment dpAssignment) {
        this.messageType = messageType;
        this.dpAssignment = dpAssignment;
    }

    public MiscCallInfoMessageType getMessageType() {
        return this.messageType;
    }

    public MiscCallInfoDpAssignment getDpAssignment() {
        return this.dpAssignment;
    }

    @Override
    public int getTag() throws INAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws INAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new INAPParsingComponentException("IOException when decoding MiscCallInfo: " + e.getMessage(), (Throwable)e, INAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new INAPParsingComponentException("AsnException when decoding MiscCallInfo: " + e.getMessage(), (Throwable)e, INAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws INAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new INAPParsingComponentException("IOException when decoding MiscCallInfo: " + e.getMessage(), (Throwable)e, INAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new INAPParsingComponentException("AsnException when decoding MiscCallInfo: " + e.getMessage(), (Throwable)e, INAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws INAPParsingComponentException, IOException, AsnException {
        this.messageType = null;
        this.dpAssignment = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        int i1 = (int)ais.readInteger();
                        this.messageType = MiscCallInfoMessageType.getInstance((int)i1);
                        continue block4;
                    }
                    case 1: {
                        int i1 = (int)ais.readInteger();
                        this.dpAssignment = MiscCallInfoDpAssignment.getInstance((int)i1);
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.messageType == null) {
            throw new INAPParsingComponentException("Error while decoding MiscCallInfo: messageType is mandatory but not found ", INAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws INAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws INAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new INAPException("AsnException when encoding MiscCallInfo: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws INAPException {
        if (this.messageType == null) {
            throw new INAPException("Error while encoding the MiscCallInfo: messageType must not be empty");
        }
        try {
            asnOs.writeInteger(2, 0, (long)this.messageType.getCode());
            if (this.dpAssignment != null) {
                asnOs.writeInteger(2, 1, (long)this.dpAssignment.getCode());
            }
        }
        catch (IOException e) {
            throw new INAPException("IOException when encoding MiscCallInfo: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new INAPException("AsnException when encoding MiscCallInfo: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.messageType != null) {
            sb.append("messageType=");
            sb.append(this.messageType);
        }
        if (this.dpAssignment != null) {
            sb.append(", dpAssignment=");
            sb.append(this.dpAssignment);
        }
        sb.append("]");
        return sb.toString();
    }
}

