/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.CalledPartyBCDNumber;
import org.mobicents.protocols.ss7.cap.api.service.sms.ConnectSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.SMSAddressString;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.primitives.CalledPartyBCDNumberImpl;
import org.mobicents.protocols.ss7.cap.service.sms.SmsMessageImpl;
import org.mobicents.protocols.ss7.cap.service.sms.primitive.SMSAddressStringImpl;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;

public class ConnectSMSRequestImpl
extends SmsMessageImpl
implements ConnectSMSRequest {
    public static final String _PrimitiveName = "ConnectSMSRequest";
    public static final int _ID_callingPartysNumber = 0;
    public static final int _ID_destinationSubscriberNumber = 1;
    public static final int _ID_smscAddress = 2;
    public static final int _ID_extensions = 10;
    private SMSAddressString callingPartysNumber;
    private CalledPartyBCDNumber destinationSubscriberNumber;
    private ISDNAddressString smscAddress;
    private CAPExtensions extensions;

    public ConnectSMSRequestImpl() {
    }

    public ConnectSMSRequestImpl(SMSAddressString callingPartysNumber, CalledPartyBCDNumber destinationSubscriberNumber, ISDNAddressString smscAddress, CAPExtensions extensions) {
        this.callingPartysNumber = callingPartysNumber;
        this.destinationSubscriberNumber = destinationSubscriberNumber;
        this.smscAddress = smscAddress;
        this.extensions = extensions;
    }

    public SMSAddressString getCallingPartysNumber() {
        return this.callingPartysNumber;
    }

    public CalledPartyBCDNumber getDestinationSubscriberNumber() {
        return this.destinationSubscriberNumber;
    }

    public ISDNAddressString getSMSCAddress() {
        return this.smscAddress;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.connectSMS_Request;
    }

    public int getOperationCode() {
        return 62;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ConnectSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ConnectSMSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.callingPartysNumber = null;
        this.destinationSubscriberNumber = null;
        this.smscAddress = null;
        this.extensions = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block6: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ConnectSMSRequest.callingPartysNumber: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.callingPartysNumber = new SMSAddressStringImpl();
                        ((SMSAddressStringImpl)this.callingPartysNumber).decodeAll(ais);
                        continue block6;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ConnectSMSRequest.destinationSubscriberNumber: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.destinationSubscriberNumber = new CalledPartyBCDNumberImpl();
                        ((CalledPartyBCDNumberImpl)this.destinationSubscriberNumber).decodeAll(ais);
                        continue block6;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ConnectSMSRequest.smscAddress: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.smscAddress = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.smscAddress).decodeAll(ais);
                        continue block6;
                    }
                    case 10: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ConnectSMSRequest.extensions: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        continue block6;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ConnectSMSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            if (this.callingPartysNumber != null) {
                ((SMSAddressStringImpl)this.callingPartysNumber).encodeAll(asnOs, 2, 0);
            }
            if (this.destinationSubscriberNumber != null) {
                ((CalledPartyBCDNumberImpl)this.destinationSubscriberNumber).encodeAll(asnOs, 2, 1);
            }
            if (this.smscAddress != null) {
                ((ISDNAddressStringImpl)this.smscAddress).encodeAll(asnOs, 2, 2);
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(asnOs, 2, 10);
            }
        }
        catch (MAPException e) {
            throw new CAPException("MAPException when encoding ConnectSMSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.callingPartysNumber != null) {
            sb.append(", callingPartysNumber=");
            sb.append(this.callingPartysNumber.toString());
        }
        if (this.destinationSubscriberNumber != null) {
            sb.append(", destinationSubscriberNumber=");
            sb.append(this.destinationSubscriberNumber.toString());
        }
        if (this.smscAddress != null) {
            sb.append(", smscAddress=");
            sb.append(this.smscAddress.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

