/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.sms;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.cap.CAPDialogImpl;
import org.mobicents.protocols.ss7.cap.CAPProviderImpl;
import org.mobicents.protocols.ss7.cap.CAPServiceBaseImpl;
import org.mobicents.protocols.ss7.cap.api.CAPApplicationContext;
import org.mobicents.protocols.ss7.cap.api.CAPDialog;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessage;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.CAPServiceListener;
import org.mobicents.protocols.ss7.cap.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.cap.api.dialog.ServingCheckResult;
import org.mobicents.protocols.ss7.cap.api.service.sms.CAPDialogSms;
import org.mobicents.protocols.ss7.cap.api.service.sms.CAPServiceSms;
import org.mobicents.protocols.ss7.cap.api.service.sms.CAPServiceSmsListener;
import org.mobicents.protocols.ss7.cap.api.service.sms.ConnectSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.ContinueSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.EventReportSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.FurnishChargingInformationSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.InitialDPSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.ReleaseSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.RequestReportSMSEventRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.ResetTimerSMSRequest;
import org.mobicents.protocols.ss7.cap.dialog.ServingCheckDataImpl;
import org.mobicents.protocols.ss7.cap.service.sms.CAPDialogSmsImpl;
import org.mobicents.protocols.ss7.cap.service.sms.ConnectSMSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.sms.ContinueSMSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.sms.EventReportSMSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.sms.FurnishChargingInformationSMSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.sms.InitialDPSMSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.sms.ReleaseSMSRequestImpl;
import org.mobicents.protocols.ss7.cap.service.sms.RequestReportSMSEventRequestImpl;
import org.mobicents.protocols.ss7.cap.service.sms.ResetTimerSMSRequestImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;

public class CAPServiceSmsImpl
extends CAPServiceBaseImpl
implements CAPServiceSms {
    protected Logger loger = Logger.getLogger(CAPServiceSmsImpl.class);

    public CAPServiceSmsImpl(CAPProviderImpl capProviderImpl) {
        super(capProviderImpl);
    }

    public CAPDialogSms createNewDialog(CAPApplicationContext appCntx, SccpAddress origAddress, SccpAddress destAddress) throws CAPException {
        return this.createNewDialog(appCntx, origAddress, destAddress, null);
    }

    public CAPDialogSms createNewDialog(CAPApplicationContext appCntx, SccpAddress origAddress, SccpAddress destAddress, Long localTrId) throws CAPException {
        if (!this.isActivated()) {
            throw new CAPException("Cannot create CAPDialogSms because CAPServiceSms is not activated");
        }
        Dialog tcapDialog = this.createNewTCAPDialog(origAddress, destAddress, localTrId);
        CAPDialogSmsImpl dialog = new CAPDialogSmsImpl(appCntx, tcapDialog, this.capProviderImpl, this);
        this.putCAPDialogIntoCollection(dialog);
        return dialog;
    }

    public void addCAPServiceListener(CAPServiceSmsListener capServiceListener) {
        super.addCAPServiceListener((CAPServiceListener)capServiceListener);
    }

    public void removeCAPServiceListener(CAPServiceSmsListener capServiceListener) {
        super.removeCAPServiceListener((CAPServiceListener)capServiceListener);
    }

    @Override
    protected CAPDialogImpl createNewDialogIncoming(CAPApplicationContext appCntx, Dialog tcapDialog) {
        return new CAPDialogSmsImpl(appCntx, tcapDialog, this.capProviderImpl, this);
    }

    public ServingCheckData isServingService(CAPApplicationContext dialogApplicationContext) {
        switch (dialogApplicationContext) {
            case CapV3_cap3_sms: 
            case CapV4_cap4_sms: {
                return new ServingCheckDataImpl(ServingCheckResult.AC_Serving);
            }
        }
        return new ServingCheckDataImpl(ServingCheckResult.AC_NotServing);
    }

    @Override
    public void processComponent(ComponentType compType, OperationCode oc, Parameter parameter, CAPDialog capDialog, Long invokeId, Long linkedId, Invoke linkedInvoke) throws CAPParsingComponentException {
        CAPDialogSmsImpl capDialogSmsImpl = (CAPDialogSmsImpl)capDialog;
        Long ocValue = oc.getLocalOperationCode();
        if (ocValue == null) {
            new CAPParsingComponentException("", CAPParsingComponentExceptionReason.UnrecognizedOperation);
        }
        CAPApplicationContext acn = capDialog.getApplicationContext();
        int ocValueInt = (int)ocValue.longValue();
        switch (ocValueInt) {
            case 62: {
                if (acn != CAPApplicationContext.CapV3_cap3_sms && acn != CAPApplicationContext.CapV4_cap4_sms || compType != ComponentType.Invoke) break;
                this.connectSMSRequest(parameter, capDialogSmsImpl, invokeId);
                break;
            }
            case 64: {
                if (acn != CAPApplicationContext.CapV3_cap3_sms && acn != CAPApplicationContext.CapV4_cap4_sms || compType != ComponentType.Invoke) break;
                this.eventReportSMSRequest(parameter, capDialogSmsImpl, invokeId);
                break;
            }
            case 61: {
                if (acn != CAPApplicationContext.CapV3_cap3_sms && acn != CAPApplicationContext.CapV4_cap4_sms || compType != ComponentType.Invoke) break;
                this.furnishChargingInformationSMSRequest(parameter, capDialogSmsImpl, invokeId);
                break;
            }
            case 60: {
                if (acn != CAPApplicationContext.CapV3_cap3_sms && acn != CAPApplicationContext.CapV4_cap4_sms || compType != ComponentType.Invoke) break;
                this.initialDPSMSRequest(parameter, capDialogSmsImpl, invokeId);
                break;
            }
            case 66: {
                if (acn != CAPApplicationContext.CapV3_cap3_sms && acn != CAPApplicationContext.CapV4_cap4_sms || compType != ComponentType.Invoke) break;
                this.releaseSMSRequest(parameter, capDialogSmsImpl, invokeId);
                break;
            }
            case 63: {
                if (acn != CAPApplicationContext.CapV3_cap3_sms && acn != CAPApplicationContext.CapV4_cap4_sms || compType != ComponentType.Invoke) break;
                this.requestReportSMSEventRequest(parameter, capDialogSmsImpl, invokeId);
                break;
            }
            case 67: {
                if (acn != CAPApplicationContext.CapV3_cap3_sms && acn != CAPApplicationContext.CapV4_cap4_sms || compType != ComponentType.Invoke) break;
                this.resetTimerSMSRequest(parameter, capDialogSmsImpl, invokeId);
                break;
            }
            case 65: {
                if (acn != CAPApplicationContext.CapV3_cap3_sms && acn != CAPApplicationContext.CapV4_cap4_sms || compType != ComponentType.Invoke) break;
                this.continueSMSRequest(parameter, capDialogSmsImpl, invokeId);
                break;
            }
            default: {
                throw new CAPParsingComponentException("", CAPParsingComponentExceptionReason.UnrecognizedOperation);
            }
        }
    }

    private void connectSMSRequest(Parameter parameter, CAPDialogSmsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding connectSMSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding connectSMSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ConnectSMSRequestImpl ind = new ConnectSMSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceSmsListener)serLis).onConnectSMSRequest((ConnectSMSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing connectSMSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void eventReportSMSRequest(Parameter parameter, CAPDialogSmsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding EventReportSMSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding EventReportSMSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        EventReportSMSRequestImpl ind = new EventReportSMSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceSmsListener)serLis).onEventReportSMSRequest((EventReportSMSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing EventReportSMSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void furnishChargingInformationSMSRequest(Parameter parameter, CAPDialogSmsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding FurnishChargingInformationSMSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding FurnishChargingInformationSMSRequest: Bad tag or tagClass or parameter is not a primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        FurnishChargingInformationSMSRequestImpl ind = new FurnishChargingInformationSMSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceSmsListener)serLis).onFurnishChargingInformationSMSRequest((FurnishChargingInformationSMSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing FurnishChargingInformationSMSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void initialDPSMSRequest(Parameter parameter, CAPDialogSmsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding InitialDPSMSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        InitialDPSMSRequestImpl ind = new InitialDPSMSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceSmsListener)serLis).onInitialDPSMSRequest((InitialDPSMSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing InitialDPSMSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void releaseSMSRequest(Parameter parameter, CAPDialogSmsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding ReleaseSMSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 4 || parameter.getTagClass() != 0 || !parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding ReleaseSMSRequest: Bad tag or tagClass or parameter is not primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ReleaseSMSRequestImpl ind = new ReleaseSMSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceSmsListener)serLis).onReleaseSMSRequest((ReleaseSMSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing ReleaseSMSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void requestReportSMSEventRequest(Parameter parameter, CAPDialogSmsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding RequestReportSMSEventRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding RequestReportSMSEventRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        RequestReportSMSEventRequestImpl ind = new RequestReportSMSEventRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceSmsListener)serLis).onRequestReportSMSEventRequest((RequestReportSMSEventRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing RequestReportSMSEventRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void resetTimerSMSRequest(Parameter parameter, CAPDialogSmsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        if (parameter == null) {
            throw new CAPParsingComponentException("Error while decoding ResetTimerSMSRequest: Parameter is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (parameter.getTag() != 16 || parameter.getTagClass() != 0 || parameter.isPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding ResetTimerSMSRequest: Bad tag or tagClass or parameter is primitive, received tag=" + parameter.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
        }
        byte[] buf = parameter.getData();
        AsnInputStream ais = new AsnInputStream(buf);
        ResetTimerSMSRequestImpl ind = new ResetTimerSMSRequestImpl();
        ind.decodeData(ais, buf.length);
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceSmsListener)serLis).onResetTimerSMSRequest((ResetTimerSMSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing ResetTimerSMSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void continueSMSRequest(Parameter parameter, CAPDialogSmsImpl capDialogImpl, Long invokeId) throws CAPParsingComponentException {
        ContinueSMSRequestImpl ind = new ContinueSMSRequestImpl();
        ind.setInvokeId(invokeId);
        ind.setCAPDialog(capDialogImpl);
        for (CAPServiceListener serLis : this.serviceListeners) {
            try {
                serLis.onCAPMessage((CAPMessage)ind);
                ((CAPServiceSmsListener)serLis).onContinueSMSRequest((ContinueSMSRequest)ind);
            }
            catch (Exception e) {
                this.loger.error((Object)("Error processing continueSMSRequest: " + e.getMessage()), (Throwable)e);
            }
        }
    }
}

