/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs.primitive;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.GPRSQoS;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.GPRSQoSExtension;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.QualityOfService;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.GPRSQoSExtensionImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.GPRSQoSImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class QualityOfServiceImpl
extends SequenceBase
implements QualityOfService {
    public static final int _ID_requestedQoS = 0;
    public static final int _ID_subscribedQoS = 1;
    public static final int _ID_negotiatedQoS = 2;
    public static final int _ID_requestedQoSExtension = 3;
    public static final int _ID_subscribedQoSExtension = 4;
    public static final int _ID_negotiatedQoSExtension = 5;
    private GPRSQoS requestedQoS;
    private GPRSQoS subscribedQoS;
    private GPRSQoS negotiatedQoS;
    private GPRSQoSExtension requestedQoSExtension;
    private GPRSQoSExtension subscribedQoSExtension;
    private GPRSQoSExtension negotiatedQoSExtension;

    public QualityOfServiceImpl() {
        super("QualityOfService");
    }

    public QualityOfServiceImpl(GPRSQoS requestedQoS, GPRSQoS subscribedQoS, GPRSQoS negotiatedQoS, GPRSQoSExtension requestedQoSExtension, GPRSQoSExtension subscribedQoSExtension, GPRSQoSExtension negotiatedQoSExtension) {
        super("QualityOfService");
        this.requestedQoS = requestedQoS;
        this.subscribedQoS = subscribedQoS;
        this.negotiatedQoS = negotiatedQoS;
        this.requestedQoSExtension = requestedQoSExtension;
        this.subscribedQoSExtension = subscribedQoSExtension;
        this.negotiatedQoSExtension = negotiatedQoSExtension;
    }

    public GPRSQoS getRequestedQoS() {
        return this.requestedQoS;
    }

    public GPRSQoS getSubscribedQoS() {
        return this.subscribedQoS;
    }

    public GPRSQoS getNegotiatedQoS() {
        return this.negotiatedQoS;
    }

    public GPRSQoSExtension getRequestedQoSExtension() {
        return this.requestedQoSExtension;
    }

    public GPRSQoSExtension getSubscribedQoSExtension() {
        return this.subscribedQoSExtension;
    }

    public GPRSQoSExtension getNegotiatedQoSExtension() {
        return this.negotiatedQoSExtension;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.requestedQoS = null;
        this.subscribedQoS = null;
        this.negotiatedQoS = null;
        this.requestedQoSExtension = null;
        this.subscribedQoSExtension = null;
        this.negotiatedQoSExtension = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".requestedQoS: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.requestedQoS = new GPRSQoSImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((GPRSQoSImpl)this.requestedQoS).decodeAll(ais2);
                        break;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".subscribedQoS: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.subscribedQoS = new GPRSQoSImpl();
                        AsnInputStream ais3 = ais.readSequenceStream();
                        ais3.readTag();
                        ((GPRSQoSImpl)this.subscribedQoS).decodeAll(ais3);
                        break;
                    }
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".negotiatedQoS: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.negotiatedQoS = new GPRSQoSImpl();
                        AsnInputStream ais4 = ais.readSequenceStream();
                        ais4.readTag();
                        ((GPRSQoSImpl)this.negotiatedQoS).decodeAll(ais4);
                        break;
                    }
                    case 3: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".requestedQoSExtension: Parameter is  primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.requestedQoSExtension = new GPRSQoSExtensionImpl();
                        ((GPRSQoSExtensionImpl)this.requestedQoSExtension).decodeAll(ais);
                        break;
                    }
                    case 4: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".subscribedQoSExtension: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.subscribedQoSExtension = new GPRSQoSExtensionImpl();
                        ((GPRSQoSExtensionImpl)this.subscribedQoSExtension).decodeAll(ais);
                        break;
                    }
                    case 5: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".negotiatedQoSExtension: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.negotiatedQoSExtension = new GPRSQoSExtensionImpl();
                        ((GPRSQoSExtensionImpl)this.negotiatedQoSExtension).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        int pos;
        if (this.requestedQoS != null) {
            try {
                asnOs.writeTag(2, false, 0);
                pos = asnOs.StartContentDefiniteLength();
                ((GPRSQoSImpl)this.requestedQoS).encodeAll(asnOs);
                asnOs.FinalizeContent(pos);
            }
            catch (AsnException e) {
                throw new CAPException("AsnException while encoding " + this._PrimitiveName + " parameter requestedQoS");
            }
        }
        if (this.subscribedQoS != null) {
            try {
                asnOs.writeTag(2, false, 1);
                pos = asnOs.StartContentDefiniteLength();
                ((GPRSQoSImpl)this.subscribedQoS).encodeAll(asnOs);
                asnOs.FinalizeContent(pos);
            }
            catch (AsnException e) {
                throw new CAPException("AsnException while encoding " + this._PrimitiveName + " parameter subscribedQoS");
            }
        }
        if (this.negotiatedQoS != null) {
            try {
                asnOs.writeTag(2, false, 2);
                pos = asnOs.StartContentDefiniteLength();
                ((GPRSQoSImpl)this.negotiatedQoS).encodeAll(asnOs);
                asnOs.FinalizeContent(pos);
            }
            catch (AsnException e) {
                throw new CAPException("AsnException while encoding " + this._PrimitiveName + " parameter negotiatedQoS");
            }
        }
        if (this.requestedQoSExtension != null) {
            ((GPRSQoSExtensionImpl)this.requestedQoSExtension).encodeAll(asnOs, 2, 3);
        }
        if (this.subscribedQoSExtension != null) {
            ((GPRSQoSExtensionImpl)this.subscribedQoSExtension).encodeAll(asnOs, 2, 4);
        }
        if (this.negotiatedQoSExtension != null) {
            ((GPRSQoSExtensionImpl)this.negotiatedQoSExtension).encodeAll(asnOs, 2, 5);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.requestedQoS != null) {
            sb.append("requestedQoS=");
            sb.append(this.requestedQoS.toString());
            sb.append(", ");
        }
        if (this.subscribedQoS != null) {
            sb.append("subscribedQoS=");
            sb.append(this.subscribedQoS.toString());
            sb.append(", ");
        }
        if (this.negotiatedQoS != null) {
            sb.append("negotiatedQoS=");
            sb.append(this.negotiatedQoS.toString());
            sb.append(", ");
        }
        if (this.requestedQoSExtension != null) {
            sb.append("requestedQoSExtension=");
            sb.append(this.requestedQoSExtension.toString());
            sb.append(", ");
        }
        if (this.subscribedQoSExtension != null) {
            sb.append("subscribedQoSExtension=");
            sb.append(this.subscribedQoSExtension.toString());
            sb.append(", ");
        }
        if (this.negotiatedQoSExtension != null) {
            sb.append("negotiatedQoSExtension=");
            sb.append(this.negotiatedQoSExtension.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

