/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs.primitive;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.MonitorMode;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.GPRSEvent;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.GPRSEventType;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class GPRSEventImpl
extends SequenceBase
implements GPRSEvent {
    public static final int _ID_gprsEventType = 0;
    public static final int _ID_monitorMode = 1;
    private GPRSEventType gprsEventType;
    private MonitorMode monitorMode;

    public GPRSEventImpl() {
        super("GPRSEvent");
    }

    public GPRSEventImpl(GPRSEventType gprsEventType, MonitorMode monitorMode) {
        super("GPRSEvent");
        this.gprsEventType = gprsEventType;
        this.monitorMode = monitorMode;
    }

    public GPRSEventType getGPRSEventType() {
        return this.gprsEventType;
    }

    public MonitorMode getMonitorMode() {
        return this.monitorMode;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.gprsEventType = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".gprsEventType: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.gprsEventType = GPRSEventType.getInstance((int)i1);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".monitorMode: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i2 = (int)ais.readInteger();
                        this.monitorMode = MonitorMode.getInstance((int)i2);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.gprsEventType == null) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": parameter gprsEventType is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.monitorMode == null) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": parameter monitorMode is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            if (this.gprsEventType == null) {
                throw new CAPException("Error while encoding " + this._PrimitiveName + ": gprsEventType must not be null");
            }
            if (this.monitorMode == null) {
                throw new CAPException("Error while encoding " + this._PrimitiveName + ": monitorMode must not be null");
            }
            asnOs.writeInteger(2, 0, (long)this.gprsEventType.getCode());
            asnOs.writeInteger(2, 1, (long)this.monitorMode.getCode());
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.gprsEventType != null) {
            sb.append("gprsEventType=");
            sb.append(this.gprsEventType.toString());
            sb.append(", ");
        }
        if (this.monitorMode != null) {
            sb.append("monitorMode=");
            sb.append(this.monitorMode.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

