/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs.primitive;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.AOCSubsequent;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.CAI_GSM0224;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.AOCGPRS;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.AOCSubsequentImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.CAI_GSM0224Impl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class AOCGPRSImpl
extends SequenceBase
implements AOCGPRS {
    public static final int _ID_aocInitial = 0;
    public static final int _ID_aocSubsequent = 1;
    private CAI_GSM0224 aocInitial;
    private AOCSubsequent aocSubsequent;

    public AOCGPRSImpl() {
        super("AOCGPRS");
    }

    public AOCGPRSImpl(CAI_GSM0224 aocInitial, AOCSubsequent aocSubsequent) {
        super("AOCGPRS");
        this.aocInitial = aocInitial;
        this.aocSubsequent = aocSubsequent;
    }

    public CAI_GSM0224 getAOCInitial() {
        return this.aocInitial;
    }

    public AOCSubsequent getAOCSubsequent() {
        return this.aocSubsequent;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.aocInitial = null;
        this.aocSubsequent = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".aocInitial: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.aocInitial = new CAI_GSM0224Impl();
                        ((CAI_GSM0224Impl)this.aocInitial).decodeAll(ais);
                        continue block4;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".aocSubsequent: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.aocSubsequent = new AOCSubsequentImpl();
                        ((AOCSubsequentImpl)this.aocSubsequent).decodeAll(ais);
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (this.aocInitial == null) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": aocInitial is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.aocInitial == null) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": aocInitial must not be null");
        }
        ((CAI_GSM0224Impl)this.aocInitial).encodeAll(asnOs, 2, 0);
        if (this.aocSubsequent != null) {
            ((AOCSubsequentImpl)this.aocSubsequent).encodeAll(asnOs, 2, 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.aocInitial != null) {
            sb.append("aocInitial=");
            sb.append(this.aocInitial.toString());
            sb.append(", ");
        }
        if (this.aocSubsequent != null) {
            sb.append("aocSubsequent=");
            sb.append(this.aocSubsequent.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

