/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.gprs;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ApplyChargingReportGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.ChargingResult;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.ChargingRollOver;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.PDPID;
import org.mobicents.protocols.ss7.cap.api.service.gprs.primitive.QualityOfService;
import org.mobicents.protocols.ss7.cap.service.gprs.GprsMessageImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.ChargingResultImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.ChargingRollOverImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.PDPIDImpl;
import org.mobicents.protocols.ss7.cap.service.gprs.primitive.QualityOfServiceImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class ApplyChargingReportGPRSRequestImpl
extends GprsMessageImpl
implements ApplyChargingReportGPRSRequest {
    public static final String _PrimitiveName = "ApplyChargingReportGPRSRequest";
    public static final int _ID_chargingResult = 0;
    public static final int _ID_qualityOfService = 1;
    public static final int _ID_active = 2;
    public static final int _ID_pdpID = 3;
    public static final int _ID_chargingRollOver = 4;
    private ChargingResult chargingResult;
    private QualityOfService qualityOfService;
    private boolean active;
    private PDPID pdpID;
    private ChargingRollOver chargingRollOver;

    public ApplyChargingReportGPRSRequestImpl() {
    }

    public ApplyChargingReportGPRSRequestImpl(ChargingResult chargingResult, QualityOfService qualityOfService, boolean active, PDPID pdpID, ChargingRollOver chargingRollOver) {
        this.chargingResult = chargingResult;
        this.qualityOfService = qualityOfService;
        this.active = active;
        this.pdpID = pdpID;
        this.chargingRollOver = chargingRollOver;
    }

    public ChargingResult getChargingResult() {
        return this.chargingResult;
    }

    public QualityOfService getQualityOfService() {
        return this.qualityOfService;
    }

    public boolean getActive() {
        return this.active;
    }

    public PDPID getPDPID() {
        return this.pdpID;
    }

    public ChargingRollOver getChargingRollOver() {
        return this.chargingRollOver;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.applyChargingGPRS_Request;
    }

    public int getOperationCode() {
        return 71;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ApplyChargingReportGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ApplyChargingReportGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ApplyChargingReportGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ApplyChargingReportGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ApplyChargingReportGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ApplyChargingReportGPRSRequest: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.chargingResult = null;
        this.qualityOfService = null;
        this.active = true;
        this.pdpID = null;
        this.chargingRollOver = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ApplyChargingReportGPRSRequest.chargingResult: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.chargingResult = new ChargingResultImpl();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        ((ChargingResultImpl)this.chargingResult).decodeAll(ais2);
                        break;
                    }
                    case 1: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ApplyChargingReportGPRSRequest.qualityOfService: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.qualityOfService = new QualityOfServiceImpl();
                        ((QualityOfServiceImpl)this.qualityOfService).decodeAll(ais);
                        break;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ApplyChargingReportGPRSRequest.active: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.active = ais.readBoolean();
                        break;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ApplyChargingReportGPRSRequest.pdpID: Parameter is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.pdpID = new PDPIDImpl();
                        ((PDPIDImpl)this.pdpID).decodeAll(ais);
                        break;
                    }
                    case 4: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding ApplyChargingReportGPRSRequest.chargingRollOver: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.chargingRollOver = new ChargingRollOverImpl();
                        AsnInputStream ais3 = ais.readSequenceStream();
                        ais3.readTag();
                        ((ChargingRollOverImpl)this.chargingRollOver).decodeAll(ais3);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.chargingResult == null) {
            throw new CAPParsingComponentException("Error while decoding ApplyChargingReportGPRSRequest: parameter chargingResult is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ApplyChargingReportGPRSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.chargingResult == null) {
            throw new CAPException("Error while encoding ApplyChargingReportGPRSRequest: chargingResult must not be null");
        }
        try {
            asnOs.writeTag(2, false, 0);
            int pos = asnOs.StartContentDefiniteLength();
            ((ChargingResultImpl)this.chargingResult).encodeAll(asnOs);
            asnOs.FinalizeContent(pos);
            if (this.qualityOfService != null) {
                ((QualityOfServiceImpl)this.qualityOfService).encodeAll(asnOs, 2, 1);
            }
            asnOs.writeBoolean(2, 2, this.active);
            if (this.pdpID != null) {
                ((PDPIDImpl)this.pdpID).encodeAll(asnOs, 2, 3);
            }
            if (this.chargingRollOver != null) {
                asnOs.writeTag(2, false, 4);
                int pos1 = asnOs.StartContentDefiniteLength();
                ((ChargingRollOverImpl)this.chargingRollOver).encodeAll(asnOs);
                asnOs.FinalizeContent(pos1);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding ApplyChargingReportGPRSRequest: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ApplyChargingReportGPRSRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplyChargingReportGPRSRequest [");
        this.addInvokeIdInfo(sb);
        if (this.chargingResult != null) {
            sb.append(", chargingResult=");
            sb.append(this.chargingResult.toString());
            sb.append(", ");
        }
        if (this.qualityOfService != null) {
            sb.append(", qualityOfService=");
            sb.append(this.qualityOfService.toString());
            sb.append(", ");
        }
        if (this.active) {
            sb.append(", active ");
            sb.append(", ");
        }
        if (this.pdpID != null) {
            sb.append(", pdpID=");
            sb.append(this.pdpID.toString());
            sb.append(", ");
        }
        if (this.chargingRollOver != null) {
            sb.append(", chargingRollOver=");
            sb.append(this.chargingRollOver.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

