/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.InbandInfo;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.InformationToSend;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.Tone;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.InbandInfoImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.ToneImpl;

public class InformationToSendImpl
implements InformationToSend,
CAPAsnPrimitive {
    public static final int _ID_inbandInfo = 0;
    public static final int _ID_tone = 1;
    public static final String _PrimitiveName = "InformationToSend";
    private static final String INBAND_INFO = "inbandInfo";
    private static final String TONE = "tone";
    private InbandInfo inbandInfo;
    private Tone tone;
    protected static final XMLFormat<InformationToSendImpl> INFORMATION_TO_SEND_XML = new XMLFormat<InformationToSendImpl>(InformationToSendImpl.class){

        public void read(XMLFormat.InputElement xml, InformationToSendImpl informationToSend) throws XMLStreamException {
            informationToSend.inbandInfo = (InbandInfo)xml.get(InformationToSendImpl.INBAND_INFO, InbandInfoImpl.class);
            informationToSend.tone = (Tone)xml.get(InformationToSendImpl.TONE, ToneImpl.class);
            int choiceCount = 0;
            if (informationToSend.inbandInfo != null) {
                ++choiceCount;
            }
            if (informationToSend.tone != null) {
                ++choiceCount;
            }
            if (choiceCount != 1) {
                throw new XMLStreamException("MessageID decoding error: there must be one choice selected, found: " + choiceCount);
            }
        }

        public void write(InformationToSendImpl informationToSend, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (informationToSend.inbandInfo != null) {
                xml.add((Object)((InbandInfoImpl)informationToSend.inbandInfo), InformationToSendImpl.INBAND_INFO, InbandInfoImpl.class);
            }
            if (informationToSend.tone != null) {
                xml.add((Object)((ToneImpl)informationToSend.tone), InformationToSendImpl.TONE, ToneImpl.class);
            }
        }
    };

    public InformationToSendImpl() {
    }

    public InformationToSendImpl(InbandInfo inbandInfo) {
        this.inbandInfo = inbandInfo;
    }

    public InformationToSendImpl(Tone tone) {
        this.tone = tone;
    }

    public InbandInfo getInbandInfo() {
        return this.inbandInfo;
    }

    public Tone getTone() {
        return this.tone;
    }

    @Override
    public int getTag() throws CAPException {
        if (this.inbandInfo != null) {
            return 0;
        }
        if (this.tone != null) {
            return 1;
        }
        throw new CAPException("Error while encoding InformationToSend: no of choices has been definite");
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding InformationToSend: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding InformationToSend: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding InformationToSend: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding InformationToSend: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.inbandInfo = null;
        this.tone = null;
        if (ais.getTagClass() != 2 || ais.isTagPrimitive()) {
            throw new CAPParsingComponentException("Error while decoding InformationToSend: bad tagClass or is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ais.getTag()) {
            case 0: {
                this.inbandInfo = new InbandInfoImpl();
                ((InbandInfoImpl)this.inbandInfo).decodeData(ais, length);
                break;
            }
            case 1: {
                this.tone = new ToneImpl();
                ((ToneImpl)this.tone).decodeData(ais, length);
                break;
            }
            default: {
                throw new CAPParsingComponentException("Error while decoding InformationToSend: bad tag: " + ais.getTag(), CAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding InformationToSend: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        int choiceCnt = 0;
        if (this.inbandInfo != null) {
            ++choiceCnt;
        }
        if (this.tone != null) {
            ++choiceCnt;
        }
        if (choiceCnt != 1) {
            throw new CAPException("Error while encoding InformationToSend: only one choice must be definite, found: " + choiceCnt);
        }
        if (this.inbandInfo != null) {
            ((InbandInfoImpl)this.inbandInfo).encodeData(asnOs);
        }
        if (this.tone != null) {
            ((ToneImpl)this.tone).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.inbandInfo != null) {
            sb.append("inbandInfo=");
            sb.append(this.inbandInfo.toString());
        }
        if (this.tone != null) {
            sb.append(" tone=");
            sb.append(this.tone.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

