/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.SendingSideID;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.SendChargingInformationRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.SCIBillingChargingCharacteristics;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.primitives.SendingSideIDImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.SCIBillingChargingCharacteristicsImpl;

public class SendChargingInformationRequestImpl
extends CircuitSwitchedCallMessageImpl
implements SendChargingInformationRequest {
    public static final int _ID_sCIBillingChargingCharacteristics = 0;
    public static final int _ID_partyToCharge = 1;
    public static final int _ID_extensions = 2;
    public static final String _PrimitiveName = "SendChargingInformationRequestIndication";
    private SCIBillingChargingCharacteristics sciBillingChargingCharacteristics;
    private SendingSideID partyToCharge;
    private CAPExtensions extensions;

    public SendChargingInformationRequestImpl() {
    }

    public SendChargingInformationRequestImpl(SCIBillingChargingCharacteristics sciBillingChargingCharacteristics, SendingSideID partyToCharge, CAPExtensions extensions) {
        this.sciBillingChargingCharacteristics = sciBillingChargingCharacteristics;
        this.partyToCharge = partyToCharge;
        this.extensions = extensions;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.sendChargingInformation_Request;
    }

    public int getOperationCode() {
        return 46;
    }

    public SCIBillingChargingCharacteristics getSCIBillingChargingCharacteristics() {
        return this.sciBillingChargingCharacteristics;
    }

    public SendingSideID getPartyToCharge() {
        return this.partyToCharge;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding SendChargingInformationRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding SendChargingInformationRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding SendChargingInformationRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding SendChargingInformationRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.sciBillingChargingCharacteristics = null;
        this.partyToCharge = null;
        this.extensions = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.sciBillingChargingCharacteristics = new SCIBillingChargingCharacteristicsImpl();
                        ((SCIBillingChargingCharacteristicsImpl)this.sciBillingChargingCharacteristics).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.partyToCharge = new SendingSideIDImpl();
                        ((SendingSideIDImpl)this.partyToCharge).decodeAll(ais2);
                        break;
                    }
                    case 2: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.sciBillingChargingCharacteristics == null || this.partyToCharge == null) {
            throw new CAPParsingComponentException("Error while decoding SendChargingInformationRequestIndication: sciBillingChargingCharacteristics and partyToCharge are mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding SendChargingInformationRequestIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.sciBillingChargingCharacteristics == null || this.partyToCharge == null) {
            throw new CAPException("Error while encoding SendChargingInformationRequestIndication: sciBillingChargingCharacteristics and partyToCharge must not be null");
        }
        try {
            ((SCIBillingChargingCharacteristicsImpl)this.sciBillingChargingCharacteristics).encodeAll(aos, 2, 0);
            aos.writeTag(2, false, 1);
            int pos = aos.StartContentDefiniteLength();
            ((SendingSideIDImpl)this.partyToCharge).encodeAll(aos);
            aos.FinalizeContent(pos);
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 2);
            }
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding SendChargingInformationRequestIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.sciBillingChargingCharacteristics != null) {
            sb.append(", sciBillingChargingCharacteristics=");
            sb.append(this.sciBillingChargingCharacteristics.toString());
        }
        if (this.partyToCharge != null) {
            sb.append(", partyToCharge=");
            sb.append(this.partyToCharge.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

