/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import java.util.ArrayList;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.GenericNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.LocationNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.OriginalCalledNumberCap;
import org.mobicents.protocols.ss7.cap.api.isup.RedirectingPartyIDCap;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ConnectRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.AlertingPatternCap;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.Carrier;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.DestinationRoutingAddress;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.NAOliInfo;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.ServiceInteractionIndicatorsTwo;
import org.mobicents.protocols.ss7.cap.isup.GenericNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.LocationNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.OriginalCalledNumberCapImpl;
import org.mobicents.protocols.ss7.cap.isup.RedirectingPartyIDCapImpl;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.AlertingPatternCapImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.CarrierImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.DestinationRoutingAddressImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.NAOliInfoImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.primitive.ServiceInteractionIndicatorsTwoImpl;
import org.mobicents.protocols.ss7.inap.api.INAPException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.inap.api.isup.CallingPartysCategoryInap;
import org.mobicents.protocols.ss7.inap.api.isup.RedirectionInformationInap;
import org.mobicents.protocols.ss7.inap.api.primitives.LegID;
import org.mobicents.protocols.ss7.inap.isup.CallingPartysCategoryInapImpl;
import org.mobicents.protocols.ss7.inap.isup.RedirectionInformationInapImpl;
import org.mobicents.protocols.ss7.inap.primitives.LegIDImpl;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.CUGInterlock;
import org.mobicents.protocols.ss7.map.primitives.ArrayListSerializingBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.CUGInterlockImpl;

public class ConnectRequestImpl
extends CircuitSwitchedCallMessageImpl
implements ConnectRequest {
    public static final int _ID_destinationRoutingAddress = 0;
    public static final int _ID_alertingPattern = 1;
    public static final int _ID_originalCalledPartyID = 6;
    public static final int _ID_extensions = 10;
    public static final int _ID_carrier = 11;
    public static final int _ID_callingPartysCategory = 28;
    public static final int _ID_redirectingPartyID = 29;
    public static final int _ID_redirectionInformation = 30;
    public static final int _ID_genericNumbers = 14;
    public static final int _ID_serviceInteractionIndicatorsTwo = 15;
    public static final int _ID_chargeNumber = 19;
    public static final int _ID_legToBeConnected = 21;
    public static final int _ID_cug_Interlock = 31;
    public static final int _ID_cug_OutgoingAccess = 32;
    public static final int _ID_suppressionOfAnnouncement = 55;
    public static final int _ID_oCSIApplicable = 56;
    public static final int _ID_naOliInfo = 57;
    public static final int _ID_bor_InterrogationRequested = 58;
    public static final int _ID_suppressNCSI = 59;
    private static final String DESTINATION_ROUTING_ADDRESS = "destinationRoutingAddress";
    private static final String ALERTING_PATTERN = "alertingPattern";
    private static final String ORIGINAL_CALLED_PARTY_ID = "originalCalledPartyID";
    private static final String EXTENSIONS = "extensions";
    private static final String CARRIER = "carrier";
    private static final String CALLING_PARTYS_CATEGORY = "callingPartysCategory";
    private static final String REDIRECTING_PARTY_ID = "redirectingPartyID";
    private static final String REDIRECTION_INFORMATION = "redirectionInformation";
    private static final String GENERIC_NUMBER = "genericNumber";
    private static final String GENERIC_NUMBER_LIST = "genericNumbersList";
    private static final String SERVICE_INTERACTION_INDICATORS_TWO = "serviceInteractionIndicatorsTwo";
    private static final String CHARGE_NUMBER = "chargeNumber";
    private static final String LEG_TO_BE_CONNECTED = "legToBeConnected";
    private static final String CUG_INTERLOCK = "cugInterlock";
    private static final String CUG_OUTGOING_ACCESS = "cugOutgoingAccess";
    private static final String SUPPRESSION_OF_ANNOUNCEMENT = "suppressionOfAnnouncement";
    private static final String OCSI_APPLICABLE = "OCSIApplicable";
    private static final String NA_OLI_INFO = "NAOliInfo";
    private static final String BOR_INTERROGATION_REQUESTED = "borInterrogationRequested";
    private static final String SUPPRESS_N_CSI = "suppressNCSI";
    public static final String _PrimitiveName = "ConnectRequestIndication";
    private DestinationRoutingAddress destinationRoutingAddress;
    private AlertingPatternCap alertingPattern;
    private OriginalCalledNumberCap originalCalledPartyID;
    private CAPExtensions extensions;
    private Carrier carrier;
    private CallingPartysCategoryInap callingPartysCategory;
    private RedirectingPartyIDCap redirectingPartyID;
    private RedirectionInformationInap redirectionInformation;
    private ArrayList<GenericNumberCap> genericNumbers;
    private ServiceInteractionIndicatorsTwo serviceInteractionIndicatorsTwo;
    private LocationNumberCap chargeNumber;
    private LegID legToBeConnected;
    private CUGInterlock cugInterlock;
    private boolean cugOutgoingAccess;
    private boolean suppressionOfAnnouncement;
    private boolean ocsIApplicable;
    private NAOliInfo naoliInfo;
    private boolean borInterrogationRequested;
    private boolean suppressNCSI;
    protected static final XMLFormat<ConnectRequestImpl> CONNECT_REQUEST_XML = new XMLFormat<ConnectRequestImpl>(ConnectRequestImpl.class){

        public void read(XMLFormat.InputElement xml, ConnectRequestImpl connectRequest) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.read(xml, (Object)connectRequest);
            connectRequest.destinationRoutingAddress = (DestinationRoutingAddress)xml.get(ConnectRequestImpl.DESTINATION_ROUTING_ADDRESS, DestinationRoutingAddressImpl.class);
            connectRequest.alertingPattern = (AlertingPatternCap)xml.get(ConnectRequestImpl.ALERTING_PATTERN, AlertingPatternCapImpl.class);
            connectRequest.originalCalledPartyID = (OriginalCalledNumberCap)xml.get(ConnectRequestImpl.ORIGINAL_CALLED_PARTY_ID, OriginalCalledNumberCapImpl.class);
            connectRequest.extensions = (CAPExtensions)xml.get(ConnectRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
            connectRequest.carrier = (Carrier)xml.get(ConnectRequestImpl.CARRIER, CarrierImpl.class);
            connectRequest.callingPartysCategory = (CallingPartysCategoryInap)xml.get(ConnectRequestImpl.CALLING_PARTYS_CATEGORY, CallingPartysCategoryInapImpl.class);
            connectRequest.redirectingPartyID = (RedirectingPartyIDCap)xml.get(ConnectRequestImpl.REDIRECTING_PARTY_ID, RedirectingPartyIDCapImpl.class);
            connectRequest.redirectionInformation = (RedirectionInformationInap)xml.get(ConnectRequestImpl.REDIRECTION_INFORMATION, RedirectionInformationInapImpl.class);
            ConnectRequest_GenericNumbers al = (ConnectRequest_GenericNumbers)((Object)xml.get(ConnectRequestImpl.GENERIC_NUMBER_LIST, ConnectRequest_GenericNumbers.class));
            if (al != null) {
                connectRequest.genericNumbers = al.getData();
            }
            connectRequest.serviceInteractionIndicatorsTwo = (ServiceInteractionIndicatorsTwo)xml.get(ConnectRequestImpl.SERVICE_INTERACTION_INDICATORS_TWO, ServiceInteractionIndicatorsTwoImpl.class);
            connectRequest.chargeNumber = (LocationNumberCap)xml.get(ConnectRequestImpl.CHARGE_NUMBER, LocationNumberCapImpl.class);
            connectRequest.legToBeConnected = (LegID)xml.get(ConnectRequestImpl.LEG_TO_BE_CONNECTED, LegIDImpl.class);
            connectRequest.cugInterlock = (CUGInterlock)xml.get(ConnectRequestImpl.CUG_INTERLOCK, CUGInterlockImpl.class);
            Boolean bval = (Boolean)xml.get(ConnectRequestImpl.CUG_OUTGOING_ACCESS, Boolean.class);
            if (bval != null) {
                connectRequest.cugOutgoingAccess = bval;
            }
            if ((bval = (Boolean)xml.get(ConnectRequestImpl.SUPPRESSION_OF_ANNOUNCEMENT, Boolean.class)) != null) {
                connectRequest.suppressionOfAnnouncement = bval;
            }
            if ((bval = (Boolean)xml.get(ConnectRequestImpl.OCSI_APPLICABLE, Boolean.class)) != null) {
                connectRequest.ocsIApplicable = bval;
            }
            connectRequest.naoliInfo = (NAOliInfo)xml.get(ConnectRequestImpl.NA_OLI_INFO, NAOliInfoImpl.class);
            bval = (Boolean)xml.get(ConnectRequestImpl.BOR_INTERROGATION_REQUESTED, Boolean.class);
            if (bval != null) {
                connectRequest.borInterrogationRequested = bval;
            }
            if ((bval = (Boolean)xml.get(ConnectRequestImpl.SUPPRESS_N_CSI, Boolean.class)) != null) {
                connectRequest.suppressNCSI = bval;
            }
        }

        public void write(ConnectRequestImpl connectRequest, XMLFormat.OutputElement xml) throws XMLStreamException {
            CircuitSwitchedCallMessageImpl.CIRCUIT_SWITCHED_CALL_MESSAGE_XML.write((Object)connectRequest, xml);
            if (connectRequest.getDestinationRoutingAddress() != null) {
                xml.add((Object)((DestinationRoutingAddressImpl)connectRequest.getDestinationRoutingAddress()), ConnectRequestImpl.DESTINATION_ROUTING_ADDRESS, DestinationRoutingAddressImpl.class);
            }
            if (connectRequest.getAlertingPattern() != null) {
                xml.add((Object)((AlertingPatternCapImpl)connectRequest.getAlertingPattern()), ConnectRequestImpl.ALERTING_PATTERN, AlertingPatternCapImpl.class);
            }
            if (connectRequest.getOriginalCalledPartyID() != null) {
                xml.add((Object)((OriginalCalledNumberCapImpl)connectRequest.getOriginalCalledPartyID()), ConnectRequestImpl.ORIGINAL_CALLED_PARTY_ID, OriginalCalledNumberCapImpl.class);
            }
            if (connectRequest.getExtensions() != null) {
                xml.add((Object)((CAPExtensionsImpl)connectRequest.getExtensions()), ConnectRequestImpl.EXTENSIONS, CAPExtensionsImpl.class);
            }
            if (connectRequest.carrier != null) {
                xml.add((Object)((CarrierImpl)connectRequest.carrier), ConnectRequestImpl.CARRIER, CarrierImpl.class);
            }
            if (connectRequest.getCallingPartysCategory() != null) {
                xml.add((Object)((CallingPartysCategoryInapImpl)connectRequest.getCallingPartysCategory()), ConnectRequestImpl.CALLING_PARTYS_CATEGORY, CallingPartysCategoryInapImpl.class);
            }
            if (connectRequest.getRedirectingPartyID() != null) {
                xml.add((Object)((RedirectingPartyIDCapImpl)connectRequest.getRedirectingPartyID()), ConnectRequestImpl.REDIRECTING_PARTY_ID, RedirectingPartyIDCapImpl.class);
            }
            if (connectRequest.getRedirectionInformation() != null) {
                xml.add((Object)((RedirectionInformationInapImpl)connectRequest.getRedirectionInformation()), ConnectRequestImpl.REDIRECTION_INFORMATION, RedirectionInformationInapImpl.class);
            }
            if (connectRequest.getGenericNumbers() != null) {
                ConnectRequest_GenericNumbers al = new ConnectRequest_GenericNumbers(connectRequest.getGenericNumbers());
                xml.add((Object)al, ConnectRequestImpl.GENERIC_NUMBER_LIST, ConnectRequest_GenericNumbers.class);
            }
            if (connectRequest.serviceInteractionIndicatorsTwo != null) {
                xml.add((Object)((ServiceInteractionIndicatorsTwoImpl)connectRequest.serviceInteractionIndicatorsTwo), ConnectRequestImpl.SERVICE_INTERACTION_INDICATORS_TWO, ServiceInteractionIndicatorsTwoImpl.class);
            }
            if (connectRequest.chargeNumber != null) {
                xml.add((Object)((LocationNumberCapImpl)connectRequest.chargeNumber), ConnectRequestImpl.CHARGE_NUMBER, LocationNumberCapImpl.class);
            }
            if (connectRequest.legToBeConnected != null) {
                xml.add((Object)((LegIDImpl)connectRequest.legToBeConnected), ConnectRequestImpl.LEG_TO_BE_CONNECTED, LegIDImpl.class);
            }
            if (connectRequest.cugInterlock != null) {
                xml.add((Object)((CUGInterlockImpl)connectRequest.cugInterlock), ConnectRequestImpl.CUG_INTERLOCK, CUGInterlockImpl.class);
            }
            if (connectRequest.cugOutgoingAccess) {
                xml.add((Object)true, ConnectRequestImpl.CUG_OUTGOING_ACCESS, Boolean.class);
            }
            if (connectRequest.getSuppressionOfAnnouncement()) {
                xml.add((Object)true, ConnectRequestImpl.SUPPRESSION_OF_ANNOUNCEMENT, Boolean.class);
            }
            if (connectRequest.getOCSIApplicable()) {
                xml.add((Object)true, ConnectRequestImpl.OCSI_APPLICABLE, Boolean.class);
            }
            if (connectRequest.getNAOliInfo() != null) {
                xml.add((Object)((NAOliInfoImpl)connectRequest.getNAOliInfo()), ConnectRequestImpl.NA_OLI_INFO, NAOliInfoImpl.class);
            }
            if (connectRequest.borInterrogationRequested) {
                xml.add((Object)true, ConnectRequestImpl.BOR_INTERROGATION_REQUESTED, Boolean.class);
            }
            if (connectRequest.suppressNCSI) {
                xml.add((Object)true, ConnectRequestImpl.SUPPRESS_N_CSI, Boolean.class);
            }
        }
    };

    public ConnectRequestImpl() {
    }

    public ConnectRequestImpl(DestinationRoutingAddress destinationRoutingAddress, AlertingPatternCap alertingPattern, OriginalCalledNumberCap originalCalledPartyID, CAPExtensions extensions, Carrier carrier, CallingPartysCategoryInap callingPartysCategory, RedirectingPartyIDCap redirectingPartyID, RedirectionInformationInap redirectionInformation, ArrayList<GenericNumberCap> genericNumbers, ServiceInteractionIndicatorsTwo serviceInteractionIndicatorsTwo, LocationNumberCap chargeNumber, LegID legToBeConnected, CUGInterlock cugInterlock, boolean cugOutgoingAccess, boolean suppressionOfAnnouncement, boolean ocsIApplicable, NAOliInfo naoliInfo, boolean borInterrogationRequested, boolean suppressNCSI) {
        this.destinationRoutingAddress = destinationRoutingAddress;
        this.alertingPattern = alertingPattern;
        this.originalCalledPartyID = originalCalledPartyID;
        this.extensions = extensions;
        this.carrier = carrier;
        this.callingPartysCategory = callingPartysCategory;
        this.redirectingPartyID = redirectingPartyID;
        this.redirectionInformation = redirectionInformation;
        this.genericNumbers = genericNumbers;
        this.serviceInteractionIndicatorsTwo = serviceInteractionIndicatorsTwo;
        this.chargeNumber = chargeNumber;
        this.legToBeConnected = legToBeConnected;
        this.cugInterlock = cugInterlock;
        this.cugOutgoingAccess = cugOutgoingAccess;
        this.suppressionOfAnnouncement = suppressionOfAnnouncement;
        this.ocsIApplicable = ocsIApplicable;
        this.naoliInfo = naoliInfo;
        this.borInterrogationRequested = borInterrogationRequested;
        this.suppressNCSI = suppressNCSI;
    }

    public CAPMessageType getMessageType() {
        return CAPMessageType.connect_Request;
    }

    public int getOperationCode() {
        return 20;
    }

    public DestinationRoutingAddress getDestinationRoutingAddress() {
        return this.destinationRoutingAddress;
    }

    public AlertingPatternCap getAlertingPattern() {
        return this.alertingPattern;
    }

    public OriginalCalledNumberCap getOriginalCalledPartyID() {
        return this.originalCalledPartyID;
    }

    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public CallingPartysCategoryInap getCallingPartysCategory() {
        return this.callingPartysCategory;
    }

    public RedirectingPartyIDCap getRedirectingPartyID() {
        return this.redirectingPartyID;
    }

    public RedirectionInformationInap getRedirectionInformation() {
        return this.redirectionInformation;
    }

    public ArrayList<GenericNumberCap> getGenericNumbers() {
        return this.genericNumbers;
    }

    public ServiceInteractionIndicatorsTwo getServiceInteractionIndicatorsTwo() {
        return this.serviceInteractionIndicatorsTwo;
    }

    public LocationNumberCap getChargeNumber() {
        return this.chargeNumber;
    }

    public LegID getLegToBeConnected() {
        return this.legToBeConnected;
    }

    public CUGInterlock getCUGInterlock() {
        return this.cugInterlock;
    }

    public boolean getCugOutgoingAccess() {
        return this.cugOutgoingAccess;
    }

    public boolean getSuppressionOfAnnouncement() {
        return this.suppressionOfAnnouncement;
    }

    public boolean getOCSIApplicable() {
        return this.ocsIApplicable;
    }

    public NAOliInfo getNAOliInfo() {
        return this.naoliInfo;
    }

    public boolean getBorInterrogationRequested() {
        return this.borInterrogationRequested;
    }

    public boolean getSuppressNCSI() {
        return this.suppressNCSI;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (INAPParsingComponentException e) {
            throw new CAPParsingComponentException("INAPParsingComponentException when decoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, MAPParsingComponentException, INAPParsingComponentException, IOException, AsnException {
        this.destinationRoutingAddress = null;
        this.alertingPattern = null;
        this.originalCalledPartyID = null;
        this.extensions = null;
        this.carrier = null;
        this.callingPartysCategory = null;
        this.redirectingPartyID = null;
        this.redirectionInformation = null;
        this.genericNumbers = null;
        this.serviceInteractionIndicatorsTwo = null;
        this.chargeNumber = null;
        this.legToBeConnected = null;
        this.cugInterlock = null;
        this.cugOutgoingAccess = false;
        this.suppressionOfAnnouncement = false;
        this.ocsIApplicable = false;
        this.naoliInfo = null;
        this.borInterrogationRequested = false;
        this.suppressNCSI = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.destinationRoutingAddress = new DestinationRoutingAddressImpl();
                        ((DestinationRoutingAddressImpl)this.destinationRoutingAddress).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        this.alertingPattern = new AlertingPatternCapImpl();
                        ((AlertingPatternCapImpl)this.alertingPattern).decodeAll(ais);
                        break;
                    }
                    case 6: {
                        this.originalCalledPartyID = new OriginalCalledNumberCapImpl();
                        ((OriginalCalledNumberCapImpl)this.originalCalledPartyID).decodeAll(ais);
                        break;
                    }
                    case 10: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    case 11: {
                        this.carrier = new CarrierImpl();
                        ((CarrierImpl)this.carrier).decodeAll(ais);
                        break;
                    }
                    case 28: {
                        this.callingPartysCategory = new CallingPartysCategoryInapImpl();
                        ((CallingPartysCategoryInapImpl)this.callingPartysCategory).decodeAll(ais);
                        break;
                    }
                    case 29: {
                        this.redirectingPartyID = new RedirectingPartyIDCapImpl();
                        ((RedirectingPartyIDCapImpl)this.redirectingPartyID).decodeAll(ais);
                        break;
                    }
                    case 30: {
                        this.redirectionInformation = new RedirectionInformationInapImpl();
                        ((RedirectionInformationInapImpl)this.redirectionInformation).decodeAll(ais);
                        break;
                    }
                    case 14: {
                        this.genericNumbers = new ArrayList();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        while (ais2.available() != 0) {
                            int tag2 = ais2.readTag();
                            if (ais2.getTagClass() != 0 || tag2 != 4) {
                                throw new CAPParsingComponentException("Error when decoding ConnectRequestIndication genericNumbers parameter SET must consist of OCTET_STRING elements", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            GenericNumberCapImpl elem = new GenericNumberCapImpl();
                            elem.decodeAll(ais2);
                            this.genericNumbers.add(elem);
                        }
                        break;
                    }
                    case 15: {
                        this.serviceInteractionIndicatorsTwo = new ServiceInteractionIndicatorsTwoImpl();
                        ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).decodeAll(ais);
                        break;
                    }
                    case 19: {
                        this.chargeNumber = new LocationNumberCapImpl();
                        ((LocationNumberCapImpl)this.chargeNumber).decodeAll(ais);
                        break;
                    }
                    case 21: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.legToBeConnected = new LegIDImpl();
                        ((LegIDImpl)this.legToBeConnected).decodeAll(ais2);
                        break;
                    }
                    case 31: {
                        this.cugInterlock = new CUGInterlockImpl();
                        ((CUGInterlockImpl)this.cugInterlock).decodeAll(ais);
                        break;
                    }
                    case 32: {
                        ais.readNull();
                        this.cugOutgoingAccess = true;
                        break;
                    }
                    case 55: {
                        ais.readNull();
                        this.suppressionOfAnnouncement = true;
                        break;
                    }
                    case 56: {
                        ais.readNull();
                        this.ocsIApplicable = true;
                        break;
                    }
                    case 57: {
                        this.naoliInfo = new NAOliInfoImpl();
                        ((NAOliInfoImpl)this.naoliInfo).decodeAll(ais);
                        break;
                    }
                    case 58: {
                        ais.readNull();
                        this.borInterrogationRequested = true;
                        break;
                    }
                    case 59: {
                        ais.readNull();
                        this.suppressNCSI = true;
                        break;
                    }
                    default: {
                        ais.advanceElement();
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.destinationRoutingAddress == null) {
            throw new CAPParsingComponentException("Error while decoding ConnectRequestIndication: destinationRoutingAddress is mandatory but not found ", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.destinationRoutingAddress == null) {
            throw new CAPException("Error while encoding ConnectRequestIndication: destinationRoutingAddress must not be null");
        }
        try {
            int pos;
            ((DestinationRoutingAddressImpl)this.destinationRoutingAddress).encodeAll(aos, 2, 0);
            if (this.alertingPattern != null) {
                ((AlertingPatternCapImpl)this.alertingPattern).encodeAll(aos, 2, 1);
            }
            if (this.originalCalledPartyID != null) {
                ((OriginalCalledNumberCapImpl)this.originalCalledPartyID).encodeAll(aos, 2, 6);
            }
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 10);
            }
            if (this.carrier != null) {
                ((CarrierImpl)this.carrier).encodeAll(aos, 2, 11);
            }
            if (this.callingPartysCategory != null) {
                ((CallingPartysCategoryInapImpl)this.callingPartysCategory).encodeAll(aos, 2, 28);
            }
            if (this.redirectingPartyID != null) {
                ((RedirectingPartyIDCapImpl)this.redirectingPartyID).encodeAll(aos, 2, 29);
            }
            if (this.redirectionInformation != null) {
                ((RedirectionInformationInapImpl)this.redirectionInformation).encodeAll(aos, 2, 30);
            }
            if (this.genericNumbers != null) {
                if (this.genericNumbers.size() < 1 || this.genericNumbers.size() > 5) {
                    throw new CAPException("Error while encoding ConnectRequestIndication: genericNumbers size must be from 1 to 5");
                }
                aos.writeTag(2, false, 14);
                pos = aos.StartContentDefiniteLength();
                for (GenericNumberCap gnc : this.genericNumbers) {
                    GenericNumberCapImpl gncc = (GenericNumberCapImpl)gnc;
                    gncc.encodeAll(aos);
                }
                aos.FinalizeContent(pos);
            }
            if (this.serviceInteractionIndicatorsTwo != null) {
                ((ServiceInteractionIndicatorsTwoImpl)this.serviceInteractionIndicatorsTwo).encodeAll(aos, 2, 15);
            }
            if (this.chargeNumber != null) {
                ((LocationNumberCapImpl)this.chargeNumber).encodeAll(aos, 2, 19);
            }
            if (this.legToBeConnected != null) {
                aos.writeTag(2, false, 21);
                pos = aos.StartContentDefiniteLength();
                ((LegIDImpl)this.legToBeConnected).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
            if (this.cugInterlock != null) {
                ((CUGInterlockImpl)this.cugInterlock).encodeAll(aos, 2, 31);
            }
            if (this.cugOutgoingAccess) {
                aos.writeNull(2, 32);
            }
            if (this.suppressionOfAnnouncement) {
                aos.writeNull(2, 55);
            }
            if (this.ocsIApplicable) {
                aos.writeNull(2, 56);
            }
            if (this.naoliInfo != null) {
                ((NAOliInfoImpl)this.naoliInfo).encodeAll(aos, 2, 57);
            }
            if (this.borInterrogationRequested) {
                aos.writeNull(2, 58);
            }
            if (this.suppressNCSI) {
                aos.writeNull(2, 59);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e);
        }
        catch (INAPException e) {
            throw new CAPException("INAPException when encoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e);
        }
        catch (MAPException e) {
            throw new CAPException("MAPException when encoding ConnectRequestIndication: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.destinationRoutingAddress != null) {
            sb.append(", destinationRoutingAddress=");
            sb.append(this.destinationRoutingAddress.toString());
        }
        if (this.alertingPattern != null) {
            sb.append(", alertingPattern=");
            sb.append(this.alertingPattern.toString());
        }
        if (this.originalCalledPartyID != null) {
            sb.append(", originalCalledPartyID=");
            sb.append(this.originalCalledPartyID.toString());
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.carrier != null) {
            sb.append(", carrier=");
            sb.append(this.carrier.toString());
        }
        if (this.callingPartysCategory != null) {
            sb.append(", callingPartysCategory=");
            sb.append(this.callingPartysCategory.toString());
        }
        if (this.redirectingPartyID != null) {
            sb.append(", redirectingPartyID=");
            sb.append(this.redirectingPartyID.toString());
        }
        if (this.redirectionInformation != null) {
            sb.append(", redirectionInformation=");
            sb.append(this.redirectionInformation.toString());
        }
        if (this.genericNumbers != null) {
            sb.append(", genericNumbers=[");
            boolean isFirst = true;
            for (GenericNumberCap gnc : this.genericNumbers) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(gnc.toString());
            }
            sb.append("]");
        }
        if (this.serviceInteractionIndicatorsTwo != null) {
            sb.append(", serviceInteractionIndicatorsTwo=");
            sb.append(this.serviceInteractionIndicatorsTwo.toString());
        }
        if (this.chargeNumber != null) {
            sb.append(", chargeNumber=");
            sb.append(this.chargeNumber.toString());
        }
        if (this.legToBeConnected != null) {
            sb.append(", legToBeConnected=");
            sb.append(this.legToBeConnected.toString());
        }
        if (this.cugInterlock != null) {
            sb.append(", cugInterlock=");
            sb.append(this.cugInterlock.toString());
        }
        if (this.cugOutgoingAccess) {
            sb.append(", cugOutgoingAccess");
        }
        if (this.suppressionOfAnnouncement) {
            sb.append(", suppressionOfAnnouncement");
        }
        if (this.ocsIApplicable) {
            sb.append(", ocsIApplicable");
        }
        if (this.naoliInfo != null) {
            sb.append(", naoliInfo=");
            sb.append(this.naoliInfo.toString());
        }
        if (this.borInterrogationRequested) {
            sb.append(", borInterrogationRequested");
        }
        if (this.suppressNCSI) {
            sb.append(", suppressNCSI");
        }
        sb.append("]");
        return sb.toString();
    }

    public static class ConnectRequest_GenericNumbers
    extends ArrayListSerializingBase<GenericNumberCap> {
        public ConnectRequest_GenericNumbers() {
            super(ConnectRequestImpl.GENERIC_NUMBER, GenericNumberCapImpl.class);
        }

        public ConnectRequest_GenericNumbers(ArrayList<GenericNumberCap> data) {
            super(ConnectRequestImpl.GENERIC_NUMBER, GenericNumberCapImpl.class, data);
        }
    }
}

