/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.primitives;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.Burst;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

public class BurstImpl
extends SequenceBase
implements Burst {
    public static final int _ID_numberOfBursts = 0;
    public static final int _ID_burstInterval = 1;
    public static final int _ID_numberOfTonesInBurst = 2;
    public static final int _ID_toneDuration = 3;
    public static final int _ID_toneInterval = 4;
    private static final String NUMBER_OF_BURSTS = "numberOfBursts";
    private static final String BURST_INTERVAL = "burstInterval";
    private static final String NUMBER_OF_TONES_IN_BURST = "numberOfTonesInBurst";
    private static final String TONE_DURATION = "toneDuration";
    private static final String TONE_INTERVAL = "toneInterval";
    private Integer numberOfBursts;
    private Integer burstInterval;
    private Integer numberOfTonesInBurst;
    private Integer toneDuration;
    private Integer toneInterval;
    protected static final XMLFormat<BurstImpl> BURST_XML = new XMLFormat<BurstImpl>(BurstImpl.class){

        public void read(XMLFormat.InputElement xml, BurstImpl burst) throws XMLStreamException {
            burst.numberOfBursts = (Integer)xml.get(BurstImpl.NUMBER_OF_BURSTS, Integer.class);
            burst.burstInterval = (Integer)xml.get(BurstImpl.BURST_INTERVAL, Integer.class);
            burst.numberOfTonesInBurst = (Integer)xml.get(BurstImpl.NUMBER_OF_TONES_IN_BURST, Integer.class);
            burst.toneDuration = (Integer)xml.get(BurstImpl.TONE_DURATION, Integer.class);
            burst.toneInterval = (Integer)xml.get(BurstImpl.TONE_INTERVAL, Integer.class);
        }

        public void write(BurstImpl burst, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (burst.numberOfBursts != null) {
                xml.add((Object)burst.numberOfBursts, BurstImpl.NUMBER_OF_BURSTS, Integer.class);
            }
            if (burst.burstInterval != null) {
                xml.add((Object)burst.burstInterval, BurstImpl.BURST_INTERVAL, Integer.class);
            }
            if (burst.numberOfTonesInBurst != null) {
                xml.add((Object)burst.numberOfTonesInBurst, BurstImpl.NUMBER_OF_TONES_IN_BURST, Integer.class);
            }
            if (burst.toneDuration != null) {
                xml.add((Object)burst.toneDuration, BurstImpl.TONE_DURATION, Integer.class);
            }
            if (burst.toneInterval != null) {
                xml.add((Object)burst.toneInterval, BurstImpl.TONE_INTERVAL, Integer.class);
            }
        }
    };

    public BurstImpl() {
        super("Burst");
    }

    public BurstImpl(Integer numberOfBursts, Integer burstInterval, Integer numberOfTonesInBurst, Integer toneDuration, Integer toneInterval) {
        super("Burst");
        this.numberOfBursts = numberOfBursts;
        this.burstInterval = burstInterval;
        this.numberOfTonesInBurst = numberOfTonesInBurst;
        this.toneDuration = toneDuration;
        this.toneInterval = toneInterval;
    }

    public Integer getNumberOfBursts() {
        return this.numberOfBursts;
    }

    public Integer getBurstInterval() {
        return this.burstInterval;
    }

    public Integer getNumberOfTonesInBurst() {
        return this.numberOfTonesInBurst;
    }

    public Integer getToneDuration() {
        return this.toneDuration;
    }

    public Integer getToneInterval() {
        return this.toneInterval;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException, INAPParsingComponentException {
        this.numberOfBursts = null;
        this.burstInterval = null;
        this.numberOfTonesInBurst = null;
        this.toneDuration = null;
        this.toneInterval = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block7: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.numberOfBursts = (int)ais.readInteger();
                        if (this.numberOfBursts >= 1 && this.numberOfBursts <= 3) continue block7;
                        throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": numberOfBursts must be 1..3, received: " + this.numberOfBursts, CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 1: {
                        this.burstInterval = (int)ais.readInteger();
                        if (this.burstInterval >= 1 && this.burstInterval <= 1200) continue block7;
                        throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": burstInterval must be 1..1200, received: " + this.burstInterval, CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 2: {
                        this.numberOfTonesInBurst = (int)ais.readInteger();
                        if (this.numberOfTonesInBurst >= 1 && this.numberOfTonesInBurst <= 3) continue block7;
                        throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": numberOfTonesInBurst must be 1..3, received: " + this.numberOfTonesInBurst, CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 3: {
                        this.toneDuration = (int)ais.readInteger();
                        if (this.toneDuration >= 1 && this.toneDuration <= 20) continue block7;
                        throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": toneDuration must be 1..20, received: " + this.toneDuration, CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 4: {
                        this.toneInterval = (int)ais.readInteger();
                        if (this.toneInterval >= 1 && this.toneInterval <= 20) continue block7;
                        throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": toneInterval must be 1..20, received: " + this.toneInterval, CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.numberOfBursts != null && (this.numberOfBursts < 1 || this.numberOfBursts > 3)) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": numberOfBursts must be 1..3, supplied: " + this.numberOfBursts);
        }
        if (this.burstInterval != null && (this.burstInterval < 1 || this.burstInterval > 1200)) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": burstInterval must be 1..1200, supplied: " + this.burstInterval);
        }
        if (this.numberOfTonesInBurst != null && (this.numberOfTonesInBurst < 1 || this.numberOfTonesInBurst > 3)) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": numberOfTonesInBurst must be 1..3, supplied: " + this.numberOfTonesInBurst);
        }
        if (this.toneDuration != null && (this.toneDuration < 1 || this.toneDuration > 20)) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": toneDuration must be 1..20, supplied: " + this.toneDuration);
        }
        if (this.toneInterval != null && (this.toneInterval < 1 || this.toneInterval > 20)) {
            throw new CAPException("Error while encoding " + this._PrimitiveName + ": toneInterval must be 1..20, supplied: " + this.toneInterval);
        }
        try {
            if (this.numberOfBursts != null) {
                aos.writeInteger(2, 0, (long)this.numberOfBursts.intValue());
            }
            if (this.burstInterval != null) {
                aos.writeInteger(2, 1, (long)this.burstInterval.intValue());
            }
            if (this.numberOfTonesInBurst != null) {
                aos.writeInteger(2, 2, (long)this.numberOfTonesInBurst.intValue());
            }
            if (this.toneDuration != null) {
                aos.writeInteger(2, 3, (long)this.toneDuration.intValue());
            }
            if (this.toneInterval != null) {
                aos.writeInteger(2, 4, (long)this.toneInterval.intValue());
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.numberOfBursts != null) {
            sb.append("numberOfBursts=");
            sb.append(this.numberOfBursts);
            sb.append(", ");
        }
        if (this.burstInterval != null) {
            sb.append("burstInterval=");
            sb.append(this.burstInterval);
            sb.append(", ");
        }
        if (this.numberOfTonesInBurst != null) {
            sb.append("numberOfTonesInBurst=");
            sb.append(this.numberOfTonesInBurst);
            sb.append(", ");
        }
        if (this.toneDuration != null) {
            sb.append("toneDuration=");
            sb.append(this.toneDuration);
            sb.append(", ");
        }
        if (this.toneInterval != null) {
            sb.append("toneInterval=");
            sb.append(this.toneInterval);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

