/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.gap;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.gap.GapIndicators;
import org.mobicents.protocols.ss7.cap.primitives.SequenceBase;

public class GapIndicatorsImpl
extends SequenceBase
implements GapIndicators {
    private static final String DURATION = "duration";
    private static final String GAP_INTERVAL = "gapInterval";
    public static final int _ID_Duration = 0;
    public static final int _ID_Gap_Interval = 1;
    private static int DEFAULT_VALUE = 0;
    private int duration;
    private int gapInterval;
    protected static final XMLFormat<GapIndicatorsImpl> GAP_INDICATORS_XML = new XMLFormat<GapIndicatorsImpl>(GapIndicatorsImpl.class){

        public void read(XMLFormat.InputElement xml, GapIndicatorsImpl gapIndicators) throws XMLStreamException {
            gapIndicators.duration = xml.getAttribute(GapIndicatorsImpl.DURATION, DEFAULT_VALUE);
            gapIndicators.gapInterval = xml.getAttribute(GapIndicatorsImpl.GAP_INTERVAL, DEFAULT_VALUE);
        }

        public void write(GapIndicatorsImpl gapIndicators, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(GapIndicatorsImpl.DURATION, gapIndicators.duration);
            xml.setAttribute(GapIndicatorsImpl.GAP_INTERVAL, gapIndicators.gapInterval);
        }
    };

    public GapIndicatorsImpl() {
        super("GapIndicators");
    }

    public GapIndicatorsImpl(int duration, int gapInterval) {
        super("GapIndicators");
        this.duration = duration;
        this.gapInterval = gapInterval;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getGapInterval() {
        return this.gapInterval;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.duration = 0;
        this.gapInterval = 0;
        boolean foundDuration = false;
        boolean foundGapInterval = false;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.duration = (int)ais.readInteger();
                        if (this.duration < -2 || this.duration > 86400) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + "-duration: possible value -2..86400, received=" + this.duration, CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        foundDuration = true;
                        continue block4;
                    }
                    case 1: {
                        this.gapInterval = (int)ais.readInteger();
                        if (this.gapInterval < -1 || this.gapInterval > 60000) {
                            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + "-gapInterval: possible value -1..60000, received=" + this.gapInterval, CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        foundGapInterval = true;
                        continue block4;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
        if (!foundDuration) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": duration parameter is not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (!foundGapInterval) {
            throw new CAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": gapInterval parameter is not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        try {
            if (this.duration < -2 || this.duration > 86400) {
                throw new CAPException("Error when encoding " + this._PrimitiveName + ": duration must be -2..86400, supplied=" + this.duration);
            }
            asnOs.writeInteger(2, 0, (long)this.duration);
            if (this.gapInterval < -1 || this.gapInterval > 60000) {
                throw new CAPException("Error when encoding " + this._PrimitiveName + ": gapInterval must be -1..60000, supplied=" + this.gapInterval);
            }
            asnOs.writeInteger(2, 1, (long)this.gapInterval);
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException ex) {
            throw new CAPException("AsnException when encoding " + this._PrimitiveName + ": " + ex.getMessage(), (Throwable)ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("duration=");
        sb.append(this.duration);
        sb.append(", gapInterval=");
        sb.append(this.gapInterval);
        sb.append("]");
        return sb.toString();
    }
}

