/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.errors;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageParameterless;
import org.mobicents.protocols.ss7.cap.errors.CAPErrorMessageImpl;

public class CAPErrorMessageParameterlessImpl
extends CAPErrorMessageImpl
implements CAPErrorMessageParameterless {
    protected static final XMLFormat<CAPErrorMessageParameterlessImpl> CAP_ERROR_MESSAGE_PARAMETERLESS_XML = new XMLFormat<CAPErrorMessageParameterlessImpl>(CAPErrorMessageParameterlessImpl.class){

        public void read(XMLFormat.InputElement xml, CAPErrorMessageParameterlessImpl errorMessage) throws XMLStreamException {
            CAPErrorMessageImpl.CAP_ERROR_MESSAGE_XML.read(xml, (Object)errorMessage);
        }

        public void write(CAPErrorMessageParameterlessImpl errorMessage, XMLFormat.OutputElement xml) throws XMLStreamException {
            CAPErrorMessageImpl.CAP_ERROR_MESSAGE_XML.write((Object)errorMessage, xml);
        }
    };

    public CAPErrorMessageParameterlessImpl(Long errorCode) {
        super(errorCode);
    }

    public CAPErrorMessageParameterlessImpl() {
        super(0L);
    }

    @Override
    public boolean isEmParameterless() {
        return true;
    }

    @Override
    public CAPErrorMessageParameterless getEmParameterless() {
        return this;
    }

    @Override
    public int getTag() throws CAPException {
        throw new CAPException("CAPErrorMessageParameterless does not support encoding");
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
    }

    public String toString() {
        return "CAPErrorMessageParameterless [errorCode=" + this.errorCode + ":" + this.capErrorCodeName() + "]";
    }

    private String capErrorCodeName() {
        if (this.errorCode == null) {
            return "N/A";
        }
        switch (this.errorCode.intValue()) {
            case 0: {
                return "canceled";
            }
            case 1: {
                return "cancelFailed";
            }
            case 3: {
                return "eTCFailed";
            }
            case 4: {
                return "improperCallerResponse";
            }
            case 6: {
                return "missingCustomerRecord";
            }
            case 7: {
                return "missingParameter";
            }
            case 8: {
                return "parameterOutOfRange";
            }
            case 10: {
                return "requestedInfoError";
            }
            case 11: {
                return "systemFailure";
            }
            case 12: {
                return "taskRefused";
            }
            case 13: {
                return "unavailableResource";
            }
            case 14: {
                return "unexpectedComponentSequence";
            }
            case 15: {
                return "unexpectedDataValue";
            }
            case 16: {
                return "unexpectedParameter";
            }
            case 51: {
                return "unknownCSID";
            }
            case 17: {
                return "unknownLegID";
            }
            case 50: {
                return "unknownPDPID";
            }
        }
        return this.errorCode.toString();
    }
}

