/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.errors;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessage;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageCancelFailed;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageParameterless;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageRequestedInfoError;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageSystemFailure;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessageTaskRefused;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;

public abstract class CAPErrorMessageImpl
implements CAPErrorMessage,
CAPAsnPrimitive {
    private static final String ERROR_CODE = "errorCode";
    protected Long errorCode;
    public static final XMLFormat<CAPErrorMessageImpl> CAP_ERROR_MESSAGE_XML = new XMLFormat<CAPErrorMessageImpl>(CAPErrorMessageImpl.class){

        public void read(XMLFormat.InputElement xml, CAPErrorMessageImpl message) throws XMLStreamException {
            message.errorCode = xml.getAttribute(CAPErrorMessageImpl.ERROR_CODE, -1L);
        }

        public void write(CAPErrorMessageImpl message, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(CAPErrorMessageImpl.ERROR_CODE, (Object)message.errorCode);
        }
    };

    protected CAPErrorMessageImpl(Long errorCode) {
        this.errorCode = errorCode;
    }

    public CAPErrorMessageImpl() {
    }

    public Long getErrorCode() {
        return this.errorCode;
    }

    public boolean isEmParameterless() {
        return false;
    }

    public boolean isEmCancelFailed() {
        return false;
    }

    public boolean isEmRequestedInfoError() {
        return false;
    }

    public boolean isEmSystemFailure() {
        return false;
    }

    public boolean isEmTaskRefused() {
        return false;
    }

    public CAPErrorMessageParameterless getEmParameterless() {
        return null;
    }

    public CAPErrorMessageCancelFailed getEmCancelFailed() {
        return null;
    }

    public CAPErrorMessageRequestedInfoError getEmRequestedInfoError() {
        return null;
    }

    public CAPErrorMessageSystemFailure getEmSystemFailure() {
        return null;
    }

    public CAPErrorMessageTaskRefused getEmTaskRefused() {
        return null;
    }
}

