/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.dialog;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPGprsReferenceNumber;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;

public class CAPGprsReferenceNumberImpl
implements CAPGprsReferenceNumber,
CAPAsnPrimitive {
    protected static final int DESTINATION_REF_TAG = 0;
    protected static final int ORIGINATION_REF_TAG = 1;
    public static final String _PrimitiveName = "CAPGprsReferenceNumber";
    public static final long[] CAP_Dialogue_OId = new long[]{0L, 4L, 0L, 0L, 1L, 1L, 5L, 2L};
    private Integer destinationReference;
    private Integer originationReference;

    public CAPGprsReferenceNumberImpl() {
    }

    public CAPGprsReferenceNumberImpl(Integer destinationReference, Integer originationReference) {
        this.destinationReference = destinationReference;
        this.originationReference = originationReference;
    }

    public Integer getDestinationReference() {
        return this.destinationReference;
    }

    public Integer getOriginationReference() {
        return this.originationReference;
    }

    public void setDestinationReference(Integer destinationReference) {
        this.destinationReference = destinationReference;
    }

    public void setOriginationReference(Integer originationReference) {
        this.originationReference = originationReference;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPGprsReferenceNumber: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPGprsReferenceNumber: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPGprsReferenceNumber: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPGprsReferenceNumber: " + e.getMessage(), (Throwable)e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.destinationReference = null;
        this.originationReference = null;
        AsnInputStream localAis = ais.readSequenceStreamData(length);
        block7: while (localAis.available() > 0) {
            int tag = localAis.readTag();
            switch (localAis.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (localAis.isTagPrimitive()) {
                                this.destinationReference = (int)localAis.readInteger();
                                continue block7;
                            }
                            AsnInputStream ais2 = localAis.readSequenceStream();
                            int tag2 = ais2.readTag();
                            if (tag2 != 2 || ais2.getTagClass() != 0) {
                                throw new CAPParsingComponentException("Error while decoding CAPGprsReferenceNumber: Bad tag or tagClass when decoding EXPLICIT destinationReference", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.destinationReference = (int)ais2.readInteger();
                            continue block7;
                        }
                        case 1: {
                            if (localAis.isTagPrimitive()) {
                                this.originationReference = (int)localAis.readInteger();
                                continue block7;
                            }
                            AsnInputStream ais2 = localAis.readSequenceStream();
                            int tag2 = ais2.readTag();
                            if (tag2 != 2 || ais2.getTagClass() != 0) {
                                throw new CAPParsingComponentException("Error while decoding CAPGprsReferenceNumber: Bad tag or tagClass when decoding EXPLICIT destinationReference", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.originationReference = (int)ais2.readInteger();
                            continue block7;
                        }
                    }
                    localAis.advanceElement();
                    continue block7;
                }
            }
            localAis.advanceElement();
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CAPGprsReferenceNumber: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        try {
            int i1;
            if (this.destinationReference != null) {
                aos.writeTag(2, false, 0);
                i1 = aos.StartContentDefiniteLength();
                aos.writeInteger(0, 2, (long)this.destinationReference.intValue());
                aos.FinalizeContent(i1);
            }
            if (this.originationReference != null) {
                aos.writeTag(2, false, 1);
                i1 = aos.StartContentDefiniteLength();
                aos.writeInteger(0, 2, (long)this.originationReference.intValue());
                aos.FinalizeContent(i1);
            }
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding CAPGprsReferenceNumber: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CAPGprsReferenceNumber: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.destinationReference != null) {
            sb.append("destinationReference=");
            sb.append(this.destinationReference);
        }
        if (this.originationReference != null) {
            sb.append(", originationReference=");
            sb.append(this.originationReference);
        }
        sb.append("]");
        return sb.toString();
    }
}

