/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.version;

import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.APIConfigFactory;
import org.mobicents.protocols.smpp.util.PropertyNotFoundException;
import org.mobicents.protocols.smpp.version.SMPPVersion;
import org.mobicents.protocols.smpp.version.VersionException;

public class VersionFactory {
    public static SMPPVersion getDefaultVersion() {
        APIConfig cfg = APIConfigFactory.getConfig();
        try {
            int versionNum = cfg.getInt("smppapi.default_version");
            return VersionFactory.getVersion(versionNum);
        }
        catch (PropertyNotFoundException x) {
            return SMPPVersion.VERSION_5_0;
        }
    }

    public static SMPPVersion getVersion(int id) {
        if (id == SMPPVersion.VERSION_3_3.getVersionID()) {
            return SMPPVersion.VERSION_3_3;
        }
        if (id == SMPPVersion.VERSION_3_4.getVersionID()) {
            return SMPPVersion.VERSION_3_4;
        }
        if (id == SMPPVersion.VERSION_5_0.getVersionID()) {
            return SMPPVersion.VERSION_5_0;
        }
        APIConfig cfg = APIConfigFactory.getConfig();
        if (cfg.getBoolean("smppapi.lax_versions", false) && id >= 0 && id <= 50) {
            return SMPPVersion.VERSION_3_3;
        }
        throw new VersionException("Unknown version id: 0x" + Integer.toHexString(id));
    }
}

