/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.version;

import org.mobicents.protocols.smpp.version.AbstractSMPPVersion;
import org.mobicents.protocols.smpp.version.MandatoryParameter;
import org.mobicents.protocols.smpp.version.VersionException;

public class SMPPVersion50
extends AbstractSMPPVersion {
    private static final long serialVersionUID = 2L;
    private static final int MAX_MSG_LENGTH = 255;

    public SMPPVersion50() {
        super(80, "SMPP version 5.0");
    }

    public int getMaxLength(MandatoryParameter mandatoryParameter) {
        switch (mandatoryParameter) {
            case SHORT_MESSAGE: {
                return 255;
            }
        }
        return Integer.MAX_VALUE;
    }

    public boolean isSupportTLV() {
        return true;
    }

    public boolean isSupported(int commandId) {
        switch (commandId & Integer.MAX_VALUE) {
            case -2147483648: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: 
            case 33: 
            case 258: 
            case 259: 
            case 273: 
            case 274: 
            case 275: {
                return true;
            }
        }
        return false;
    }

    public void validateMessage(byte[] message, int start, int length) {
        if (message != null && length > 255) {
            throw new VersionException("Message is too long: " + length);
        }
    }

    public void validateMessageId(String messageId) {
        if (messageId != null && messageId.length() > 64) {
            throw new VersionException("Invalid message ID: " + messageId);
        }
    }

    public void validatePriorityFlag(int priority) {
        if (priority < 0 || priority > 4) {
            throw new VersionException("Invalid message priority: " + priority);
        }
    }

    public void validateRegisteredDelivery(int registeredDelivery) {
        if (registeredDelivery < 0 || registeredDelivery > 31) {
            throw new VersionException("Invalid registered delivery: " + registeredDelivery);
        }
    }

    public void validateNumberOfDests(int num) {
        if (num < 0 || num > 255) {
            throw new VersionException("Invalid number of destinations: " + num);
        }
    }
}

