/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.version;

import org.mobicents.protocols.smpp.version.AbstractSMPPVersion;
import org.mobicents.protocols.smpp.version.MandatoryParameter;
import org.mobicents.protocols.smpp.version.VersionException;

public class SMPPVersion33
extends AbstractSMPPVersion {
    private static final long serialVersionUID = 2L;
    private static final int MAX_MSG_LENGTH = 140;

    SMPPVersion33() {
        super(51, "SMPP version 3.3");
    }

    public boolean isSupported(int commandID) {
        switch (commandID & Integer.MAX_VALUE) {
            case -2147483648: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 21: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return true;
            }
        }
        return false;
    }

    public boolean isSupportTLV() {
        return false;
    }

    public int getMaxLength(MandatoryParameter mandatoryParameter) {
        switch (mandatoryParameter) {
            case SHORT_MESSAGE: {
                return 140;
            }
        }
        return Integer.MAX_VALUE;
    }

    public void validateMessage(byte[] message, int start, int length) {
        if (message != null && length > 140) {
            throw new VersionException("Message is too long: " + length);
        }
    }

    public void validateMessageId(String messageId) {
        try {
            if (messageId != null && messageId.length() > 8) {
                throw new VersionException("Invalid message ID: " + messageId);
            }
            Long.parseLong(messageId, 16);
        }
        catch (NumberFormatException x) {
            throw new VersionException("Message ID must be a hex number: " + messageId);
        }
    }

    public void validatePriorityFlag(int priority) {
        if (priority < 0 || priority > 1) {
            throw new VersionException("Priority flag must be 0 or 1: " + priority);
        }
    }

    public void validateRegisteredDelivery(int registeredDelivery) {
        if (registeredDelivery < 0 || registeredDelivery > 1) {
            throw new VersionException("Registered flag must be 0 or 1: " + registeredDelivery);
        }
    }

    public void validateNumberOfDests(int num) {
        if (num < 0 || num > 255) {
            throw new VersionException("Invalid number of destinations: " + num);
        }
    }

    public void validateParamName(String paramName) {
        if (paramName != null && paramName.length() > 31) {
            throw new VersionException("Parameter name too long: " + paramName);
        }
    }

    public void validateParamValue(String paramValue) {
        if (paramValue != null && paramValue.length() > 100) {
            throw new VersionException("Parameter value too long: " + paramValue);
        }
    }
}

