/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.version;

import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.version.SMPPVersion;
import org.mobicents.protocols.smpp.version.VersionException;

public abstract class AbstractSMPPVersion
implements SMPPVersion {
    private static final long serialVersionUID = 2L;
    private int versionID;
    private String versionString;

    protected AbstractSMPPVersion(int versionID, String versionString) {
        this.versionID = versionID;
        this.versionString = versionString;
    }

    public int getVersionID() {
        return this.versionID;
    }

    public boolean isOlderThan(SMPPVersion otherVersion) {
        return this.versionID < otherVersion.getVersionID();
    }

    public boolean isNewerThan(SMPPVersion otherVersion) {
        return this.versionID > otherVersion.getVersionID();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SMPPVersion)) {
            return false;
        }
        return ((SMPPVersion)obj).getVersionID() == this.versionID;
    }

    public int hashCode() {
        return new Integer(this.versionID).hashCode();
    }

    public boolean equals(int versionID) {
        return versionID == this.versionID;
    }

    public String toString() {
        return this.versionString;
    }

    public void validateTon(int ton) {
        if (ton < 0 || ton > 255) {
            throw new VersionException("Invalid TON: " + ton);
        }
    }

    public void validateNpi(int npi) {
        if (npi < 0 || npi > 255) {
            throw new VersionException("Invalid NPI: " + npi);
        }
    }

    public void validateAddress(Address address) {
        if (address != null) {
            this.validateTon(address.getTON());
            this.validateNpi(address.getNPI());
            String addr = address.getAddress();
            if (addr != null && addr.length() > 20) {
                throw new VersionException("Address is too long, 20 max: " + addr);
            }
        }
    }

    public void validateEsmClass(int esmClass) {
        if (esmClass < 0 || esmClass > 255) {
            throw new VersionException("Invalid ESM class: " + esmClass);
        }
    }

    public void validateProtocolID(int protocolId) {
        if (protocolId < 0 || protocolId > 255) {
            throw new VersionException("Invalid protocol ID: " + protocolId);
        }
    }

    public void validateDataCoding(int dataCoding) {
        if (dataCoding < 0 || dataCoding > 255) {
            throw new VersionException("Invalid data coding: " + dataCoding);
        }
    }

    public void validateDefaultMsg(int defaultMsgId) {
        if (defaultMsgId < 0 || defaultMsgId > 255) {
            throw new VersionException("Invalid default message ID: " + defaultMsgId);
        }
    }

    public void validateServiceType(String serviceType) {
        if (serviceType != null && serviceType.length() > 5) {
            throw new VersionException("Invalid service type: " + serviceType);
        }
    }

    public void validateMessageState(int messageState) {
        if (messageState < 0 || messageState > 255) {
            throw new VersionException("Invalid message state: " + messageState);
        }
    }

    public void validateErrorCode(int code) {
        if (code < 0 || code > 255) {
            throw new VersionException("Invalid error code: " + code);
        }
    }

    public void validateReplaceIfPresent(int flag) {
        if (flag < 0 || flag > 1) {
            throw new VersionException("Replace-if-present flag must be 0 or 1: " + flag);
        }
    }

    public void validateNumUnsuccessful(int num) {
        if (num < 0 || num > 255) {
            throw new VersionException("Invalid number of unsuccessful destinations: " + num);
        }
    }

    public void validateDistListName(String name) {
        if (name != null && name.length() > 20) {
            throw new VersionException("Distribution list name too long: " + name);
        }
    }

    public void validateSystemId(String sysId) {
        if (sysId != null && sysId.length() > 15) {
            throw new VersionException("System ID too long: " + sysId);
        }
    }

    public void validatePassword(String password) {
        if (password != null && password.length() > 8) {
            throw new VersionException("Password too long");
        }
    }

    public void validateSystemType(String sysType) {
        if (sysType != null && sysType.length() > 12) {
            throw new VersionException("System type too long: " + sysType);
        }
    }

    public void validateAddressRange(String addressRange) {
        if (addressRange != null && addressRange.length() > 40) {
            throw new VersionException("Address range too long: " + addressRange);
        }
    }

    public void validateParamName(String paramName) {
        throw new VersionException("Parameter retrieval is not supported.");
    }

    public void validateParamValue(String paramValue) {
        throw new VersionException("Parameter retrieval is not supported.");
    }
}

