/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mobicents.protocols.smpp.IllegalStateException;
import org.mobicents.protocols.smpp.Session;
import org.mobicents.protocols.smpp.SessionType;
import org.mobicents.protocols.smpp.event.SMPPEvent;
import org.mobicents.protocols.smpp.event.SessionObserver;
import org.mobicents.protocols.smpp.message.Bind;
import org.mobicents.protocols.smpp.message.BindReceiver;
import org.mobicents.protocols.smpp.message.BindResp;
import org.mobicents.protocols.smpp.message.BindTransceiver;
import org.mobicents.protocols.smpp.message.BindTransmitter;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.message.Unbind;
import org.mobicents.protocols.smpp.message.UnbindResp;
import org.mobicents.protocols.smpp.net.ReadTimeoutException;
import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.APIConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncWrapper
implements SessionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(SyncWrapper.class);
    private Session connection;
    private Map<Number, SMPPPacket> blockers = new HashMap<Number, SMPPPacket>();
    private List<SMPPPacket> packetQueue = new ArrayList<SMPPPacket>();
    private long packetTimeout;
    private ConnectionCaller bindCaller = new ConnectionCaller(){

        public void execute(Session connection, SMPPPacket packet) throws IOException {
            connection.bind((Bind)packet);
        }
    };
    private ConnectionCaller packetCaller = new ConnectionCaller(){

        public void execute(Session connection, SMPPPacket packet) throws IOException {
            connection.sendPacket(packet);
        }
    };

    public SyncWrapper(Session connection) {
        this.connection = connection;
    }

    public BindResp bind(SessionType type, String systemID, String password, String systemType) throws IOException {
        return this.bind(type, systemID, password, systemType, 0, 0, null);
    }

    public BindResp bind(SessionType type, String systemID, String password, String systemType, int typeOfNumber, int numberPlanIndicator, String addressRange) throws IOException {
        Bind bindRequest = type == SessionType.TRANSMITTER ? new BindTransmitter() : (type == SessionType.RECEIVER ? new BindReceiver() : new BindTransceiver());
        bindRequest.setVersion(this.connection.getVersion());
        bindRequest.setSystemId(systemID);
        bindRequest.setPassword(password);
        bindRequest.setSystemType(systemType);
        bindRequest.setAddressTon(typeOfNumber);
        bindRequest.setAddressNpi(numberPlanIndicator);
        bindRequest.setAddressRange(addressRange);
        return this.bind(bindRequest);
    }

    public BindResp bind(Bind bindRequest) throws IOException {
        long timeout = this.getBindTimeout();
        BindResp bindResp = (BindResp)this.sendAndWait(bindRequest, this.bindCaller, timeout);
        if (bindResp == null) {
            throw new ReadTimeoutException();
        }
        return bindResp;
    }

    public UnbindResp unbind() throws IOException {
        UnbindResp unbindResp = (UnbindResp)this.sendAndWait(new Unbind(), this.packetCaller, this.packetTimeout);
        if (unbindResp == null) {
            throw new ReadTimeoutException();
        }
        return unbindResp;
    }

    public SMPPPacket sendPacket(SMPPPacket packet) throws IOException {
        SMPPPacket response = this.sendAndWait(packet, this.packetCaller, this.packetTimeout);
        if (response == null) {
            throw new ReadTimeoutException();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packetReceived(Session source, SMPPPacket packet) {
        if (packet.isResponse()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response received: there are {} threads blocked.", (Object)this.blockers.size());
            }
            Number seq = null;
            Map<Number, SMPPPacket> map = this.blockers;
            synchronized (map) {
                seq = new Long(packet.getSequenceNum());
                seq = this.getKeyObject(seq);
                if (seq != null) {
                    this.blockers.put(seq, packet);
                    Number number = seq;
                    synchronized (number) {
                        seq.notify();
                    }
                } else {
                    LOG.debug("No blocker thread waiting on packet {}", (Object)seq);
                    this.addToQueue(packet);
                }
            }
        } else {
            this.addToQueue(packet);
        }
    }

    public void update(Session source, SMPPEvent event) {
        LOG.warn("SyncWrapper ignoring an SMPP event.");
    }

    public boolean isPacketAvailable() {
        return this.packetQueue.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMPPPacket readNextPacket(boolean block) throws IOException {
        SMPPPacket packet = null;
        try {
            List<SMPPPacket> list = this.packetQueue;
            synchronized (list) {
                if (this.packetQueue.size() < 1 && block) {
                    this.packetQueue.wait();
                } else {
                    packet = this.packetQueue.remove(0);
                }
            }
        }
        catch (InterruptedException x) {
            LOG.info("Thread interrupted while blocked waiting on a packet.");
        }
        return packet;
    }

    public long getPacketTimeout() {
        return this.packetTimeout;
    }

    public void setPacketTimeout(long packetTimeout) {
        this.packetTimeout = packetTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAllBlocked() {
        Map<Number, SMPPPacket> map = this.blockers;
        synchronized (map) {
            Iterator<Number> iter = this.blockers.keySet().iterator();
            while (iter.hasNext()) {
                Number seq;
                Number number = seq = iter.next();
                synchronized (number) {
                    seq.notify();
                }
            }
        }
    }

    private Number getKeyObject(Number seq) {
        for (Number value : this.blockers.keySet()) {
            if (!value.equals(seq)) continue;
            return value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToQueue(SMPPPacket packet) {
        List<SMPPPacket> list = this.packetQueue;
        synchronized (list) {
            this.packetQueue.add(packet);
            this.packetQueue.notify();
        }
    }

    private long getBindTimeout() {
        APIConfig config = APIConfigFactory.getConfig();
        return config.getLong("smppapi.connection.bind_timeout", 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SMPPPacket sendAndWait(SMPPPacket packet, ConnectionCaller caller, long timeout) throws IOException {
        Long seq;
        if (packet.getSequenceNum() < 0L) {
            long nextSeq = this.connection.getSequenceNumberScheme().nextNumber();
            seq = new Long(nextSeq);
        } else {
            seq = new Long(packet.getSequenceNum());
        }
        Map<Number, SMPPPacket> nextSeq = this.blockers;
        synchronized (nextSeq) {
            if (this.blockers.containsKey(seq)) {
                throw new IllegalStateException("Got a duplicate sequence number!");
            }
            this.blockers.put(seq, null);
        }
        packet.setSequenceNum(seq);
        SMPPPacket response = null;
        try {
            Long l = seq;
            synchronized (l) {
                caller.execute(this.connection, packet);
                seq.wait(timeout);
            }
        }
        catch (InterruptedException x) {
            LOG.debug("Thread interrupted while waiting on response packet {}.", (Object)seq);
        }
        finally {
            Map<Number, SMPPPacket> map = this.blockers;
            synchronized (map) {
                response = this.blockers.remove(seq);
            }
        }
        return response;
    }

    private static interface ConnectionCaller {
        public void execute(Session var1, SMPPPacket var2) throws IOException;
    }
}

