/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mobicents.protocols.smpp.SMPPRuntimeException;

public final class SMPPIO {
    private static final String US_ASCII = "US-ASCII";

    private SMPPIO() {
    }

    public static String readCString(byte[] bytes, int offset) {
        try {
            int endIndex = offset;
            while (bytes[endIndex] != 0) {
                ++endIndex;
            }
            return new String(bytes, offset, endIndex - offset, US_ASCII);
        }
        catch (UnsupportedEncodingException x) {
            throw new SMPPRuntimeException("JVM does not support ASCII!", x);
        }
    }

    public static String readString(byte[] bytes, int offset, int length) {
        try {
            if (offset + length > bytes.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            return new String(bytes, offset, length, US_ASCII);
        }
        catch (UnsupportedEncodingException x) {
            throw new SMPPRuntimeException("JVM does not support ASCII??", x);
        }
    }

    public static int readUInt1(byte[] b, int offset) {
        return b[offset] & 0xFF;
    }

    public static int readUInt2(byte[] b, int offset) {
        int value = b[offset + 1] & 0xFF;
        return value |= (b[offset] & 0xFF) << 8;
    }

    public static int readInt4(byte[] b, int offset) {
        int value = b[offset + 3] & 0xFF;
        value |= (b[offset] & 0xFF) << 24;
        value |= (b[offset + 1] & 0xFF) << 16;
        return value |= (b[offset + 2] & 0xFF) << 8;
    }

    public static long readUInt4(byte[] b, int offset) {
        long value = (long)b[offset + 3] & 0xFFL;
        value |= ((long)b[offset] & 0xFFL) << 24;
        value |= ((long)b[offset + 1] & 0xFFL) << 16;
        return value |= ((long)b[offset + 2] & 0xFFL) << 8;
    }

    public static long readInt8(byte[] b, int offset) {
        long value = (long)b[offset + 7] & 0xFFL;
        value |= ((long)b[offset] & 0xFFL) << 56;
        value |= ((long)b[offset + 1] & 0xFFL) << 48;
        value |= ((long)b[offset + 2] & 0xFFL) << 40;
        value |= ((long)b[offset + 3] & 0xFFL) << 32;
        value |= ((long)b[offset + 4] & 0xFFL) << 24;
        value |= ((long)b[offset + 5] & 0xFFL) << 16;
        return value |= ((long)b[offset + 6] & 0xFFL) << 8;
    }

    public static void writeByte(int b, OutputStream out) throws IOException {
        out.write(b);
    }

    public static void writeShort(int value, OutputStream out) throws IOException {
        out.write(value >>> 8);
        out.write(value);
    }

    public static void writeInt(int value, OutputStream out) throws IOException {
        out.write(value >>> 24);
        out.write(value >>> 16);
        out.write(value >>> 8);
        out.write(value);
    }

    public static void writeLongInt(long value, OutputStream out) throws IOException {
        out.write((int)(value >>> 24));
        out.write((int)(value >>> 16));
        out.write((int)(value >>> 8));
        out.write((int)value);
    }

    public static void writeLong(long value, OutputStream out) throws IOException {
        out.write((int)(value >>> 56));
        out.write((int)(value >>> 48));
        out.write((int)(value >>> 40));
        out.write((int)(value >>> 32));
        out.write((int)(value >>> 24));
        out.write((int)(value >>> 16));
        out.write((int)(value >>> 8));
        out.write((int)value);
    }

    public static void writeCString(String s, OutputStream out) throws IOException {
        SMPPIO.writeString(s, out);
        out.write(0);
    }

    public static void writeString(String s, int len, OutputStream out) throws IOException {
        if (s != null) {
            byte[] b = s.getBytes(US_ASCII);
            out.write(b, 0, len);
        }
    }

    public static void writeString(String s, OutputStream out) throws IOException {
        if (s != null) {
            out.write(s.getBytes(US_ASCII));
        }
    }
}

