/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.mobicents.protocols.smpp.SMPPRuntimeException;
import org.mobicents.protocols.smpp.util.SMPPDate;

public class SMPPDateFormat
extends Format {
    private static final long serialVersionUID = 2L;
    private static final String ABS_FORMAT_12 = "{0,number,00}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}";
    private static final String ABS_FORMAT_16 = "{0,number,00}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}{6,number,0}{7,number,00}{8}";
    private static final String REL_FORMAT_16 = "{0,number,00}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}000R";
    private static final Pattern ABS_PATTERN_16 = Pattern.compile("^\\d{15}[+-]");
    private static final Pattern REL_PATTERN_16 = Pattern.compile("^\\d{15}R");
    private static final Pattern ABS_PATTERN_12 = Pattern.compile("^\\d{12}");
    public static final int DEFAULT_YEAR_MODIFIER = 2000;
    private int yearModifier = 2000;

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (toAppendTo == null || pos == null) {
            throw new NullPointerException();
        }
        if (obj == null) {
            return toAppendTo;
        }
        if (!(obj instanceof SMPPDate)) {
            throw new IllegalArgumentException("Cannot format an object of type " + obj.getClass().getName());
        }
        SMPPDate date = (SMPPDate)obj;
        int year = date.getYear();
        String format = ABS_FORMAT_16;
        if (date.isAbsolute()) {
            year -= this.yearModifier;
            if (!date.hasTimezone()) {
                format = ABS_FORMAT_12;
            }
        } else if (date.isRelative()) {
            format = REL_FORMAT_16;
        }
        Object[] args = new Object[]{year, date.getMonth(), date.getDay(), date.getHour(), date.getMinute(), date.getSecond(), date.getTenth(), date.getUtcOffset(), Character.valueOf(date.getSign())};
        toAppendTo.append(MessageFormat.format(format, args));
        return toAppendTo;
    }

    public Object parseObject(String source, ParsePosition pos) {
        String s = source;
        if (pos.getIndex() > 0) {
            s = source.substring(pos.getIndex());
        }
        int updatePos = 0;
        boolean absolute = false;
        boolean hasTz = true;
        if (ABS_PATTERN_16.matcher(s).find()) {
            absolute = true;
            updatePos = 16;
        } else if (REL_PATTERN_16.matcher(s).find()) {
            absolute = false;
            updatePos = 16;
        } else if (ABS_PATTERN_12.matcher(s).find()) {
            absolute = true;
            hasTz = false;
            updatePos = 12;
        } else {
            return null;
        }
        SMPPDate date = null;
        try {
            date = absolute ? this.parseAbsoluteDate(s, pos, hasTz) : this.parseRelativeDate(s, pos);
            pos.setIndex(pos.getIndex() + updatePos);
        }
        catch (SMPPRuntimeException x) {
            // empty catch block
        }
        return date;
    }

    public int getYearModifier() {
        return this.yearModifier;
    }

    public void setYearModifier(int yearModifier) {
        this.yearModifier = yearModifier;
    }

    private SMPPDate parseAbsoluteDate(String s, ParsePosition pos, boolean hasTz) {
        Calendar cal;
        int index = pos.getIndex();
        int year = this.parseAndCheck(s, pos, index, index + 2, 0, 99);
        int month = this.parseAndCheck(s, pos, index + 2, index + 4, 1, 12);
        int day = this.parseAndCheck(s, pos, index + 4, index + 6, 1, 31);
        int hour = this.parseAndCheck(s, pos, index + 6, index + 8, 0, 23);
        int minute = this.parseAndCheck(s, pos, index + 8, index + 10, 0, 59);
        int second = this.parseAndCheck(s, pos, index + 10, index + 12, 0, 59);
        if (hasTz) {
            char sign = s.charAt(index + 15);
            int tenth = this.parseAndCheck(s, pos, index + 12, index + 13, 0, 9);
            int utcOffset = this.parseAndCheck(s, pos, index + 13, index + 15, 0, 48);
            cal = this.getCalendar(year, month, day, hour, minute, second, tenth, utcOffset, sign);
        } else {
            cal = this.getCalendar(year, month, day, hour, minute, second, 0, 0, '\u0000');
        }
        return SMPPDate.getAbsoluteInstance(cal, hasTz);
    }

    private SMPPDate parseRelativeDate(String s, ParsePosition pos) {
        int index = pos.getIndex();
        int year = this.parseAndCheck(s, pos, index, index + 2, 0, 99);
        int month = this.parseAndCheck(s, pos, index + 2, index + 4, 0, 99);
        int day = this.parseAndCheck(s, pos, index + 4, index + 6, 0, 99);
        int hour = this.parseAndCheck(s, pos, index + 6, index + 8, 0, 99);
        int minute = this.parseAndCheck(s, pos, index + 8, index + 10, 0, 99);
        int second = this.parseAndCheck(s, pos, 10, 12, 0, 99);
        return SMPPDate.getRelativeInstance(year, month, day, hour, minute, second);
    }

    private Calendar getCalendar(int year, int month, int day, int hour, int minute, int second, int tenths, int utcOffset, char sign) {
        Calendar calendar = Calendar.getInstance();
        if (sign != '\u0000') {
            calendar.setTimeZone(this.getTimeZoneForOffset(utcOffset, sign));
        }
        calendar.set(1, year + this.yearModifier);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, tenths * 100);
        return calendar;
    }

    private TimeZone getTimeZoneForOffset(int utcOffset, char sign) {
        int rawOffset = utcOffset * 900000;
        if (sign == '-') {
            rawOffset = -rawOffset;
        }
        int hours = utcOffset / 4;
        int minutes = (utcOffset - hours * 4) * 15;
        String id = String.format("UTC%c%02d:%02d", Character.valueOf(sign), hours, minutes);
        SimpleTimeZone tz = new SimpleTimeZone(rawOffset, id);
        return tz;
    }

    private int parseAndCheck(String s, ParsePosition pos, int start, int end, int min, int max) {
        try {
            int n = Integer.parseInt(s.substring(start, end));
            if (n < min || n > max) {
                throw new NumberFormatException();
            }
            return n;
        }
        catch (NumberFormatException x) {
            pos.setErrorIndex(start);
            throw new SMPPRuntimeException();
        }
    }
}

