/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.util.Properties;
import org.mobicents.protocols.smpp.SMPPRuntimeException;
import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.AbstractAPIConfig;
import org.mobicents.protocols.smpp.util.PropertyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesAPIConfig
extends AbstractAPIConfig
implements APIConfig,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesAPIConfig.class);
    private static final String[] SEARCH_PATH = new String[]{"", "com/", "com/adenki/", "com/adenki/smpp/", "com/adenki/smpp/util/"};
    private static final String PROPS_RESOURCE = "smppapi.properties";
    private URL propsURL;
    private Properties properties = new Properties();

    public PropertiesAPIConfig() {
        this.propsURL = this.getDefaultPropertiesResource();
    }

    public PropertiesAPIConfig(URL propertiesURL) {
        this.propsURL = propertiesURL;
    }

    public boolean isSet(String property) {
        return this.properties.containsKey(property);
    }

    public void initialise() {
        LOG.debug("Initialising API properties.");
        try {
            this.loadAPIProperties();
        }
        catch (IOException x) {
            throw new SMPPRuntimeException("Could not load API config", x);
        }
    }

    public boolean reloadAPIConfig() {
        LOG.debug("Reloading API config properties.");
        try {
            this.properties.clear();
            this.loadAPIProperties();
        }
        catch (IOException x) {
            LOG.warn("Could not reload API properties.", (Throwable)x);
            return false;
        }
        return true;
    }

    public void reconfigure(URL newURL) throws IOException {
        this.propsURL = newURL;
        this.properties.clear();
        this.loadAPIProperties();
    }

    public String getProperty(String property) throws PropertyNotFoundException {
        String val = this.properties.getProperty(property);
        if (val == null) {
            throw new PropertyNotFoundException(property);
        }
        return val;
    }

    public void setProperty(String property, String value) {
        this.properties.setProperty(property, value);
    }

    public Object remove(String property) {
        return this.properties.remove(property);
    }

    private URL getDefaultPropertiesResource() {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        for (int i = 0; i < SEARCH_PATH.length && url == null; ++i) {
            url = loader.getResource(SEARCH_PATH[i] + PROPS_RESOURCE);
        }
        return url;
    }

    private void loadAPIProperties() throws IOException {
        if (this.propsURL != null) {
            this.properties.load(this.propsURL.openStream());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded API properties from {}", (Object)this.propsURL);
                StringWriter w = new StringWriter();
                this.properties.list(new PrintWriter(w));
                LOG.debug("\n" + w.toString());
            }
        }
    }
}

