/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.mobicents.protocols.smpp.BadCommandIDException;
import org.mobicents.protocols.smpp.SMPPRuntimeException;
import org.mobicents.protocols.smpp.message.AlertNotification;
import org.mobicents.protocols.smpp.message.BindReceiver;
import org.mobicents.protocols.smpp.message.BindReceiverResp;
import org.mobicents.protocols.smpp.message.BindTransceiver;
import org.mobicents.protocols.smpp.message.BindTransceiverResp;
import org.mobicents.protocols.smpp.message.BindTransmitter;
import org.mobicents.protocols.smpp.message.BindTransmitterResp;
import org.mobicents.protocols.smpp.message.BroadcastSM;
import org.mobicents.protocols.smpp.message.BroadcastSMResp;
import org.mobicents.protocols.smpp.message.CancelBroadcastSM;
import org.mobicents.protocols.smpp.message.CancelBroadcastSMResp;
import org.mobicents.protocols.smpp.message.CancelSM;
import org.mobicents.protocols.smpp.message.CancelSMResp;
import org.mobicents.protocols.smpp.message.DataSM;
import org.mobicents.protocols.smpp.message.DataSMResp;
import org.mobicents.protocols.smpp.message.DeliverSM;
import org.mobicents.protocols.smpp.message.DeliverSMResp;
import org.mobicents.protocols.smpp.message.EnquireLink;
import org.mobicents.protocols.smpp.message.EnquireLinkResp;
import org.mobicents.protocols.smpp.message.GenericNack;
import org.mobicents.protocols.smpp.message.Outbind;
import org.mobicents.protocols.smpp.message.ParamRetrieve;
import org.mobicents.protocols.smpp.message.ParamRetrieveResp;
import org.mobicents.protocols.smpp.message.QueryBroadcastSM;
import org.mobicents.protocols.smpp.message.QueryBroadcastSMResp;
import org.mobicents.protocols.smpp.message.QueryLastMsgs;
import org.mobicents.protocols.smpp.message.QueryLastMsgsResp;
import org.mobicents.protocols.smpp.message.QueryMsgDetails;
import org.mobicents.protocols.smpp.message.QueryMsgDetailsResp;
import org.mobicents.protocols.smpp.message.QuerySM;
import org.mobicents.protocols.smpp.message.QuerySMResp;
import org.mobicents.protocols.smpp.message.ReplaceSM;
import org.mobicents.protocols.smpp.message.ReplaceSMResp;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.message.SubmitMulti;
import org.mobicents.protocols.smpp.message.SubmitMultiResp;
import org.mobicents.protocols.smpp.message.SubmitSM;
import org.mobicents.protocols.smpp.message.SubmitSMResp;
import org.mobicents.protocols.smpp.message.Unbind;
import org.mobicents.protocols.smpp.message.UnbindResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PacketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PacketFactory.class);
    private final Map<Integer, Class<? extends SMPPPacket>> commands = new HashMap<Integer, Class<? extends SMPPPacket>>();
    private final Map<Integer, Class<? extends SMPPPacket>> userCommands = new HashMap<Integer, Class<? extends SMPPPacket>>();

    public PacketFactory() {
        this.add(new AlertNotification());
        this.add(new BindReceiver(), new BindReceiverResp());
        this.add(new BindTransceiver(), new BindTransceiverResp());
        this.add(new BindTransmitter(), new BindTransmitterResp());
        this.add(new BroadcastSM(), new BroadcastSMResp());
        this.add(new CancelBroadcastSM(), new CancelBroadcastSMResp());
        this.add(new CancelSM(), new CancelSMResp());
        this.add(new DataSM(), new DataSMResp());
        this.add(new DeliverSM(), new DeliverSMResp());
        this.add(new EnquireLink(), new EnquireLinkResp());
        this.add(new GenericNack());
        this.add(new Outbind());
        this.add(new ParamRetrieve(), new ParamRetrieveResp());
        this.add(new QueryBroadcastSM(), new QueryBroadcastSMResp());
        this.add(new QueryLastMsgs(), new QueryLastMsgsResp());
        this.add(new QueryMsgDetails(), new QueryMsgDetailsResp());
        this.add(new QuerySM(), new QuerySMResp());
        this.add(new ReplaceSM(), new ReplaceSMResp());
        this.add(new SubmitMulti(), new SubmitMultiResp());
        this.add(new SubmitSM(), new SubmitSMResp());
        this.add(new Unbind(), new UnbindResp());
    }

    public SMPPPacket newInstance(int id) {
        return this.newInstance(id, null);
    }

    public SMPPPacket newResponse(SMPPPacket packet) {
        if (packet.isResponse()) {
            throw new SMPPRuntimeException("Cannot create a response to a response!");
        }
        int id = packet.getCommandId();
        SMPPPacket response = this.newInstance(id | Integer.MIN_VALUE, packet);
        response.setSequenceNum(packet.getSequenceNum());
        return response;
    }

    public void registerVendorPacket(int id, Class<? extends SMPPPacket> requestType, Class<? extends SMPPPacket> responseType) {
        this.userCommands.put(id, requestType);
        if (responseType != null) {
            this.userCommands.put(id | Integer.MIN_VALUE, responseType);
        }
    }

    public void unregisterVendorPacket(int id) {
        this.userCommands.remove(id);
        this.userCommands.remove(id | Integer.MIN_VALUE);
    }

    private void add(SMPPPacket command) {
        int commandId = command.getCommandId();
        Class<?> commandClass = command.getClass();
        this.commands.put(commandId, commandClass);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Mapping id 0x{} to class {}", (Object)Integer.toHexString(commandId), (Object)commandClass.getName());
        }
    }

    private void add(SMPPPacket request, SMPPPacket response) {
        this.add(request);
        if (response != null) {
            this.add(response);
        }
    }

    private SMPPPacket newInstance(int id, SMPPPacket request) {
        SMPPPacket response = null;
        Class<? extends SMPPPacket> clazz = this.getClassForId(id);
        if (clazz == null) {
            throw new BadCommandIDException("Unrecognized command id " + Integer.toHexString(id), id);
        }
        try {
            if (request != null) {
                response = this.constructWithPacketArg(clazz, request);
            }
            if (response == null) {
                response = clazz.newInstance();
            }
        }
        catch (Exception x) {
            throw new SMPPRuntimeException("Packet constructor threw an exception.", x);
        }
        return response;
    }

    private SMPPPacket constructWithPacketArg(Class<? extends SMPPPacket> clazz, SMPPPacket request) throws Exception {
        SMPPPacket packet = null;
        try {
            Constructor<? extends SMPPPacket> cons = clazz.getConstructor(SMPPPacket.class);
            packet = cons.newInstance(request);
        }
        catch (NoSuchMethodException x) {
            LOG.debug("No SMPPPacket constructor; will fall back to default.");
        }
        return packet;
    }

    private Class<? extends SMPPPacket> getClassForId(int commandId) {
        Integer id = commandId;
        Class<? extends SMPPPacket> clazz = this.commands.get(id);
        if (clazz == null) {
            clazz = this.userCommands.get(id);
        }
        return clazz;
    }
}

