/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.io.IOException;
import java.io.OutputStream;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.ErrorAddress;
import org.mobicents.protocols.smpp.util.PacketEncoder;
import org.mobicents.protocols.smpp.util.SMPPDate;
import org.mobicents.protocols.smpp.util.SMPPDateFormat;

public class PacketEncoderImpl
implements PacketEncoder {
    private static final SMPPDateFormat DATE_FORMAT = new SMPPDateFormat();
    private OutputStream out;

    public PacketEncoderImpl() {
    }

    public PacketEncoderImpl(OutputStream stream) {
        this.out = stream;
    }

    public PacketEncoder setStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public OutputStream getStream() {
        return this.out;
    }

    public PacketEncoder writeCString(String value) throws IOException {
        if (value != null) {
            this.out.write(value.getBytes("US-ASCII"));
        }
        this.out.write(0);
        return this;
    }

    public PacketEncoder writeString(String value, int length) throws IOException {
        if (length > value.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(length));
        }
        byte[] array = value.getBytes("US-ASCII");
        this.out.write(array, 0, length);
        return this;
    }

    public PacketEncoder writeUInt1(int value) throws IOException {
        this.out.write(value);
        return this;
    }

    public PacketEncoder writeUInt2(int value) throws IOException {
        this.out.write(value >>> 8);
        this.out.write(value);
        return this;
    }

    public PacketEncoder writeUInt4(long value) throws IOException {
        this.out.write((int)(value >>> 24));
        this.out.write((int)(value >>> 16));
        this.out.write((int)(value >>> 8));
        this.out.write((int)value);
        return this;
    }

    public PacketEncoder writeInt4(int value) throws IOException {
        this.out.write(value >>> 24);
        this.out.write(value >>> 16);
        this.out.write(value >>> 8);
        this.out.write(value);
        return this;
    }

    public PacketEncoder writeInt8(long value) throws IOException {
        this.out.write((int)(value >>> 56));
        this.out.write((int)(value >>> 48));
        this.out.write((int)(value >>> 40));
        this.out.write((int)(value >>> 32));
        this.out.write((int)(value >>> 24));
        this.out.write((int)(value >>> 16));
        this.out.write((int)(value >>> 8));
        this.out.write((int)value);
        return this;
    }

    public PacketEncoder writeAddress(Address address) throws IOException {
        if (address != null) {
            address.writeTo(this);
        } else {
            new Address().writeTo(this);
        }
        return this;
    }

    public PacketEncoder writeErrorAddress(ErrorAddress errorAddress) throws IOException {
        if (errorAddress != null) {
            errorAddress.writeTo(this);
        } else {
            new ErrorAddress().writeTo(this);
        }
        return this;
    }

    public PacketEncoder writeDate(SMPPDate date) throws IOException {
        String str = DATE_FORMAT.format(date);
        this.writeCString(str);
        return this;
    }

    public PacketEncoder writeBytes(byte[] bytes) throws IOException {
        return this.writeBytes(bytes, 0, bytes.length);
    }

    public PacketEncoder writeBytes(byte[] bytes, int offset, int length) throws IOException {
        if (bytes != null) {
            this.out.write(bytes, offset, length);
        } else if (length != 0) {
            throw new IndexOutOfBoundsException(Integer.toString(offset));
        }
        return this;
    }
}

