/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.text.ParseException;
import org.mobicents.protocols.smpp.Address;
import org.mobicents.protocols.smpp.ErrorAddress;
import org.mobicents.protocols.smpp.message.SMPPProtocolException;
import org.mobicents.protocols.smpp.util.PacketDecoder;
import org.mobicents.protocols.smpp.util.SMPPDate;
import org.mobicents.protocols.smpp.util.SMPPDateFormat;
import org.mobicents.protocols.smpp.util.SMPPIO;

public class PacketDecoderImpl
implements PacketDecoder {
    private static final SMPPDateFormat DATE_FORMAT = new SMPPDateFormat();
    private byte[] bytes;
    private int pos;

    public PacketDecoderImpl() {
    }

    public PacketDecoderImpl(byte[] bytes) {
        this.bytes = bytes;
    }

    public PacketDecoderImpl(byte[] bytes, int parsePosition) {
        this.bytes = bytes;
        this.pos = parsePosition;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getParsePosition() {
        return this.pos;
    }

    public void setParsePosition(int pos) {
        this.pos = pos;
    }

    public int getAvailableBytes() {
        return this.bytes.length - this.pos;
    }

    public byte readByte() {
        int index = this.pos++;
        return this.bytes[index];
    }

    public String readCString() {
        String str = SMPPIO.readCString(this.bytes, this.pos);
        this.pos += str.length() + 1;
        return str;
    }

    public String readString(int length) {
        String str = SMPPIO.readString(this.bytes, this.pos, length);
        this.pos += str.length();
        return str;
    }

    public int readUInt1() {
        int value = SMPPIO.readUInt1(this.bytes, this.pos);
        ++this.pos;
        return value;
    }

    public int readUInt2() {
        int value = SMPPIO.readUInt2(this.bytes, this.pos);
        this.pos += 2;
        return value;
    }

    public long readUInt4() {
        long value = SMPPIO.readUInt4(this.bytes, this.pos);
        this.pos += 4;
        return value;
    }

    public long readInt8() {
        long value = SMPPIO.readInt8(this.bytes, this.pos);
        this.pos += 8;
        return value;
    }

    public Address readAddress() {
        Address address = new Address();
        address.readFrom(this);
        return address;
    }

    public ErrorAddress readErrorAddress() {
        ErrorAddress errorAddress = new ErrorAddress();
        errorAddress.readFrom(this);
        return errorAddress;
    }

    public SMPPDate readDate() {
        SMPPDate date = null;
        String str = null;
        try {
            str = this.readCString();
            if (str.length() > 0) {
                date = (SMPPDate)DATE_FORMAT.parseObject(str);
            }
        }
        catch (ParseException x) {
            throw new SMPPProtocolException("Cannot parse date value: " + str, x);
        }
        return date;
    }

    public byte[] readBytes(int length) {
        int startIndex = this.pos;
        if (startIndex + length > this.bytes.length) {
            throw new ArrayIndexOutOfBoundsException(startIndex + length);
        }
        byte[] copy = new byte[length];
        System.arraycopy(this.bytes, startIndex, copy, 0, length);
        this.pos += length;
        return copy;
    }
}

