/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.mobicents.protocols.smpp.SMPPRuntimeException;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static void imageToBwBitmap(BufferedImage image, ByteBuffer buffer) {
        int width = image.getWidth();
        int height = image.getHeight();
        int bytesWidth = width / 8 + 1;
        if (width % 8 == 0) {
            --bytesWidth;
        }
        if (buffer.remaining() < bytesWidth * height) {
            throw new SMPPRuntimeException("Insufficient space to for bitmap data");
        }
        int bit = 7;
        int currentByte = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int colour = image.getRGB(x, y);
                if ((colour & 0xFFFFFF) != 0xFFFFFF) {
                    currentByte |= 1 << bit;
                }
                if (--bit >= 0) continue;
                buffer.put((byte)currentByte);
                bit = 7;
                currentByte = 0;
            }
        }
    }
}

