/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.util.concurrent.atomic.AtomicLong;
import org.mobicents.protocols.smpp.util.SequenceNumberScheme;

public class DefaultSequenceScheme
implements SequenceNumberScheme {
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    private long start = 1L;
    private AtomicLong sequence = new AtomicLong(1L);

    public DefaultSequenceScheme() {
    }

    public DefaultSequenceScheme(long start) {
        this.start = start;
        this.sequence.set(start);
    }

    public long nextNumber() {
        long next;
        long current;
        while (!this.sequence.compareAndSet(current, next = (current = this.sequence.get()) < 0xFFFFFFFFL ? current + 1L : this.start)) {
        }
        return current;
    }

    public long peek() {
        return this.sequence.get();
    }

    public long peek(long nth) {
        return this.sequence.get() + nth;
    }

    public void reset() {
        this.sequence.set(this.start);
    }
}

