/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.io.IOException;
import org.mobicents.protocols.smpp.Session;
import org.mobicents.protocols.smpp.event.SMPPEvent;
import org.mobicents.protocols.smpp.event.SessionObserver;
import org.mobicents.protocols.smpp.message.DataSM;
import org.mobicents.protocols.smpp.message.DataSMResp;
import org.mobicents.protocols.smpp.message.DeliverSM;
import org.mobicents.protocols.smpp.message.DeliverSMResp;
import org.mobicents.protocols.smpp.message.EnquireLink;
import org.mobicents.protocols.smpp.message.EnquireLinkResp;
import org.mobicents.protocols.smpp.message.SMPPPacket;
import org.mobicents.protocols.smpp.message.Unbind;
import org.mobicents.protocols.smpp.message.UnbindResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoResponder
implements SessionObserver {
    private static final Logger LOG = LoggerFactory.getLogger(AutoResponder.class);
    private boolean ackUnbind;
    private boolean ackDeliverSm;
    private boolean ackDataSm;
    private boolean ackEnquireLink;

    public AutoResponder() {
    }

    public AutoResponder(boolean respond) {
        this.ackDataSm = this.ackEnquireLink = respond;
        this.ackDeliverSm = this.ackEnquireLink;
        this.ackUnbind = this.ackEnquireLink;
    }

    public boolean isAckDataSm() {
        return this.ackDataSm;
    }

    public void setAckDataSm(boolean ackDataSm) {
        this.ackDataSm = ackDataSm;
    }

    public boolean isAckDeliverSm() {
        return this.ackDeliverSm;
    }

    public void setAckDeliverSm(boolean ackDeliverSm) {
        this.ackDeliverSm = ackDeliverSm;
    }

    public boolean isAckEnquireLink() {
        return this.ackEnquireLink;
    }

    public void setAckEnquireLink(boolean ackEnquireLink) {
        this.ackEnquireLink = ackEnquireLink;
    }

    public boolean isAckUnbind() {
        return this.ackUnbind;
    }

    public void setAckUnbind(boolean ackUnbind) {
        this.ackUnbind = ackUnbind;
    }

    public void packetReceived(Session source, SMPPPacket packet) {
        switch (packet.getCommandId()) {
            case 5: {
                if (!this.ackDeliverSm) break;
                this.respond(source, new DeliverSMResp((DeliverSM)packet));
                break;
            }
            case 259: {
                if (!this.ackDataSm) break;
                this.respond(source, new DataSMResp((DataSM)packet));
                break;
            }
            case 21: {
                if (!this.ackEnquireLink) break;
                this.respond(source, new EnquireLinkResp((EnquireLink)packet));
                break;
            }
            case 6: {
                if (!this.ackUnbind) break;
                this.respond(source, new UnbindResp((Unbind)packet));
            }
        }
    }

    public void update(Session source, SMPPEvent event) {
    }

    private void respond(Session connection, SMPPPacket response) {
        try {
            connection.sendPacket(response);
        }
        catch (IOException x) {
            LOG.error("IOException while trying to send packet {}: {}", (Object)response, (Object)x.getMessage());
            LOG.debug("Stack trace", (Throwable)x);
        }
    }
}

