/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.util.HashMap;
import java.util.Map;
import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.InvalidConfigurationException;
import org.mobicents.protocols.smpp.util.PropertyNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAPIConfig
implements APIConfig {
    private static final Map<String, Boolean> BOOLEANS = new HashMap<String, Boolean>();

    @Override
    public boolean isSet(String property) {
        try {
            this.getProperty(property);
            return true;
        }
        catch (PropertyNotFoundException x) {
            return false;
        }
    }

    @Override
    public String getProperty(String property, String defaultValue) {
        try {
            return this.getProperty(property);
        }
        catch (PropertyNotFoundException x) {
            return defaultValue;
        }
    }

    @Override
    public short getShort(String property) throws InvalidConfigurationException, PropertyNotFoundException {
        long value = this.getInt(property);
        if (value < -32768L || value > 32767L) {
            throw new InvalidConfigurationException("Property value exceeds valid short range: " + value, property);
        }
        return (short)value;
    }

    @Override
    public short getShort(String property, short defaultValue) {
        short s;
        try {
            s = this.getShort(property);
        }
        catch (PropertyNotFoundException x) {
            s = defaultValue;
        }
        return s;
    }

    @Override
    public int getInt(String property) throws InvalidConfigurationException, PropertyNotFoundException {
        long value = this.convertToNumber(this.getProperty(property));
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new InvalidConfigurationException("Property value exceeds valid integer range: " + value, property);
        }
        return (int)value;
    }

    @Override
    public int getInt(String property, int defaultValue) {
        int value;
        try {
            value = this.getInt(property);
        }
        catch (PropertyNotFoundException x) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public long getLong(String property) throws InvalidConfigurationException, PropertyNotFoundException {
        return this.convertToNumber(this.getProperty(property));
    }

    @Override
    public long getLong(String property, long defaultValue) {
        long l;
        try {
            l = this.getLong(property);
        }
        catch (PropertyNotFoundException x) {
            l = defaultValue;
        }
        return l;
    }

    @Override
    public boolean getBoolean(String property) throws InvalidConfigurationException, PropertyNotFoundException {
        return this.toBoolean(this.getProperty(property));
    }

    @Override
    public boolean getBoolean(String property, boolean defaultValue) {
        boolean value;
        try {
            value = this.getBoolean(property);
        }
        catch (PropertyNotFoundException x) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public <T> T getClassInstance(String property, Class<T> type) {
        String className = this.getProperty(property);
        try {
            Class<?> clazz = Class.forName(className);
            if (!type.isAssignableFrom(clazz)) {
                throw new InvalidConfigurationException(className + " is not an instance of " + type, className);
            }
            Object obj = clazz.newInstance();
            return (T)obj;
        }
        catch (Exception x) {
            throw new InvalidConfigurationException("Could not instantiate a " + className, x);
        }
    }

    @Override
    public <T> T getClassInstance(String property, Class<T> type, T defaultValue) {
        try {
            return this.getClassInstance(property, type);
        }
        catch (PropertyNotFoundException x) {
            return defaultValue;
        }
    }

    protected boolean toBoolean(String value) {
        Boolean bool = BOOLEANS.get(value);
        if (bool == null) {
            try {
                bool = Integer.parseInt(value) != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (NumberFormatException x) {
                throw new InvalidConfigurationException("Invalid boolean property", value);
            }
        }
        return bool;
    }

    protected long convertToNumber(String num) throws NumberFormatException {
        String s;
        int base = 10;
        long multiplier = 1L;
        char firstChar = num.charAt(0);
        char lastChar = num.charAt(num.length() - 1);
        if (num.startsWith("0x") || num.startsWith("0X")) {
            base = 16;
            s = num.substring(2);
        } else if (lastChar == 'b') {
            base = 2;
            s = num.substring(0, num.length() - 1);
        } else if (lastChar == 'k') {
            multiplier = 1024L;
            s = num.substring(0, num.length() - 1);
        } else if (lastChar == 'm') {
            multiplier = 0x100000L;
            s = num.substring(0, num.length() - 1);
        } else if (firstChar == '0' && num.length() > 1) {
            base = 8;
            s = num.substring(1);
        } else {
            s = num;
        }
        return Long.parseLong(s, base) * multiplier;
    }

    static {
        BOOLEANS.put("1", Boolean.TRUE);
        BOOLEANS.put("true", Boolean.TRUE);
        BOOLEANS.put("on", Boolean.TRUE);
        BOOLEANS.put("yes", Boolean.TRUE);
        BOOLEANS.put("0", Boolean.FALSE);
        BOOLEANS.put("false", Boolean.FALSE);
        BOOLEANS.put("off", Boolean.FALSE);
        BOOLEANS.put("no", Boolean.FALSE);
    }
}

