/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.util.Calendar;
import java.util.TimeZone;
import org.mobicents.protocols.smpp.util.SMPPDate;

class AbsoluteSMPPDate
extends SMPPDate {
    private static final long serialVersionUID = 2L;
    private Calendar calendar;
    private boolean hasTimeZone;

    AbsoluteSMPPDate(Calendar calendar) {
        this(calendar, true);
    }

    AbsoluteSMPPDate(Calendar calendar, boolean withTimeZone) {
        this.calendar = calendar;
        this.hasTimeZone = withTimeZone;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public int getYear() {
        return this.calendar.get(1);
    }

    public int getTenth() {
        return this.calendar.get(14) / 100;
    }

    public boolean hasTimezone() {
        return this.hasTimeZone;
    }

    public boolean isAbsolute() {
        return true;
    }

    public TimeZone getTimeZone() {
        if (this.hasTimeZone) {
            return this.calendar.getTimeZone();
        }
        return null;
    }

    public int getUtcOffset() {
        if (this.hasTimeZone) {
            TimeZone tz = this.calendar.getTimeZone();
            int offset = Math.abs(tz.getOffset(System.currentTimeMillis()));
            return offset / 900000;
        }
        return 0;
    }

    public char getSign() {
        TimeZone tz;
        int offset;
        int sign = !this.hasTimeZone ? 0 : ((offset = (tz = this.calendar.getTimeZone()).getOffset(System.currentTimeMillis())) >= 0 ? 43 : 45);
        return (char)sign;
    }

    public int getLength() {
        return this.hasTimeZone ? 17 : 13;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AbsoluteSMPPDate)) {
            return false;
        }
        AbsoluteSMPPDate other = (AbsoluteSMPPDate)obj;
        return this.hasTimeZone == other.hasTimeZone && this.compareCalendarFields(this.calendar, other.calendar);
    }

    public int hashCode() {
        int hc1 = this.calendar.hashCode();
        return hc1 + (this.hasTimeZone ? 6203 : 7907);
    }

    public String toString() {
        return new StringBuffer(this.calendar.toString()).append(" hasTz=").append(this.hasTimeZone).toString();
    }

    private boolean compareCalendarFields(Calendar calendar1, Calendar calendar2) {
        int tenth2;
        boolean equal = true;
        equal &= this.compareField(calendar1, calendar2, 1);
        equal &= this.compareField(calendar1, calendar2, 2);
        equal &= this.compareField(calendar1, calendar2, 5);
        equal &= this.compareField(calendar1, calendar2, 11);
        equal &= this.compareField(calendar1, calendar2, 12);
        equal &= this.compareField(calendar1, calendar2, 13);
        int tenth1 = calendar1.get(14) / 100;
        equal &= tenth1 == (tenth2 = calendar2.get(14) / 100);
        if (this.hasTimeZone) {
            int rawOffset2;
            int rawOffset1 = calendar1.getTimeZone().getRawOffset();
            equal &= rawOffset1 == (rawOffset2 = calendar2.getTimeZone().getRawOffset());
        }
        return equal;
    }

    private boolean compareField(Calendar calendar1, Calendar calendar2, int field) {
        return calendar1.get(field) == calendar2.get(field);
    }
}

