/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.mobicents.protocols.smpp.gsm.GSMError;
import org.mobicents.protocols.smpp.message.MessageState;
import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.APIConfigFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class APIMessages {
    public static final String BUNDLE_PROPERTY = "smppapi.bundle";
    public static final String DEFAULT_BUNDLE_NAME = "smpp_messages";
    private static final Logger LOG = LoggerFactory.getLogger(APIMessages.class);
    private static final String PACKET_STATUS_PREFIX = "packet.status.";
    private static final String MESSAGE_STATE_PREFIX = "message.state.";
    private static final String GSM_ERROR_PREFIX = "gsm.errors.";
    private ResourceBundle bundle;

    public APIMessages() {
        this.loadBundle();
    }

    public String getPacketStatus(int statusCode) {
        StringBuilder resource = new StringBuilder(PACKET_STATUS_PREFIX);
        resource.append("0x");
        resource.append(Integer.toHexString(statusCode).toLowerCase());
        return this.bundle.getString(resource.toString());
    }

    public String getMessageState(MessageState state) {
        StringBuilder resource = new StringBuilder(MESSAGE_STATE_PREFIX);
        resource.append("0x");
        resource.append(Integer.toHexString(state.getValue()).toLowerCase());
        return this.bundle.getString(resource.toString());
    }

    public String getGSMError(GSMError error) {
        StringBuilder resource = new StringBuilder(GSM_ERROR_PREFIX);
        resource.append(error.name().toLowerCase());
        return this.bundle.getString(resource.toString());
    }

    private void loadBundle() {
        try {
            this.bundle = ResourceBundle.getBundle(this.getBundleName());
        }
        catch (MissingResourceException x) {
            LOG.warn("Cannot load API messages.");
            this.bundle = this.getDummyBundle();
        }
    }

    private String getBundleName() {
        APIConfig cfg = APIConfigFactory.getConfig();
        return cfg.getProperty(BUNDLE_PROPERTY, DEFAULT_BUNDLE_NAME);
    }

    private ResourceBundle getDummyBundle() {
        return new ResourceBundle(){

            @Override
            protected Object handleGetObject(String key) {
                return key;
            }

            @Override
            public Enumeration<String> getKeys() {
                return new Vector().elements();
            }
        };
    }
}

