/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.util;

import org.mobicents.protocols.smpp.util.APIConfig;
import org.mobicents.protocols.smpp.util.InvalidConfigurationException;
import org.mobicents.protocols.smpp.util.PropertiesAPIConfig;

public final class APIConfigFactory {
    public static final String CONFIG_CLASS_PROP = "org.mobicents.smpp.configClass";
    public static final String CACHE_CONFIG_PROP = "org.mobicents.smpp.cacheConfig";
    private static APIConfig cachedConfig;

    private APIConfigFactory() {
    }

    public static final APIConfig getConfig() {
        boolean cacheConfig = APIConfigFactory.readCacheConfig();
        if (cachedConfig != null) {
            return cachedConfig;
        }
        APIConfig config = APIConfigFactory.loadConfig();
        if (cacheConfig) {
            cachedConfig = config;
        }
        return config;
    }

    public static final APIConfig loadConfig() {
        String className = null;
        try {
            ClassLoader loader = APIConfigFactory.getClassLoader();
            className = APIConfigFactory.getConfigClassName();
            Class<?> clazz = loader.loadClass(className);
            if (!APIConfig.class.isAssignableFrom(clazz)) {
                throw new InvalidConfigurationException("Class " + className + " does not implement " + APIConfig.class.getName());
            }
            APIConfig config = (APIConfig)clazz.newInstance();
            config.initialise();
            return config;
        }
        catch (ClassNotFoundException x) {
            throw new InvalidConfigurationException("Cannot find class " + className);
        }
        catch (InstantiationException x) {
            throw new InvalidConfigurationException("Constructor in class " + className + " threw an exception", x);
        }
        catch (IllegalAccessException x) {
            throw new InvalidConfigurationException("Constructor in class " + className + " is not visible");
        }
    }

    public static final void setCachedConfig(APIConfig apiConfig) {
        cachedConfig = apiConfig;
    }

    public static final void reset() {
        cachedConfig = null;
    }

    private static boolean readCacheConfig() {
        boolean cacheConfig = true;
        String value = System.getProperty(CACHE_CONFIG_PROP);
        if (value != null && ("false".equals(value = value.trim().toLowerCase()) || "no".equals(value) || "off".equals(value))) {
            cacheConfig = false;
        }
        return cacheConfig;
    }

    private static ClassLoader getClassLoader() {
        Thread currentThread = Thread.currentThread();
        ClassLoader loader = currentThread.getContextClassLoader();
        if (loader == null) {
            loader = APIConfigFactory.class.getClassLoader();
        }
        return loader;
    }

    private static String getConfigClassName() {
        String value = System.getProperty(CONFIG_CLASS_PROP);
        if (value != null) {
            return value;
        }
        return PropertiesAPIConfig.class.getName();
    }
}

