/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.mobicents.protocols.smpp.net.AbstractStreamLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpLink
extends AbstractStreamLink {
    private static final String STACK_TRACE_ERR = "Stack trace:";
    private static final String SOCKET_NOT_OPEN_ERR = "Socket connection is not open";
    private static final Logger LOG = LoggerFactory.getLogger(TcpLink.class);
    public static final int DEFAULT_PORT = 5016;
    private InetAddress addr;
    private int port;
    private int sockTimeout;
    private Socket sock;

    public TcpLink(String address) throws UnknownHostException {
        this(address, 5016);
    }

    public TcpLink(String address, int port) throws UnknownHostException {
        this.addr = InetAddress.getByName(address);
        this.port = port < 1 ? 5016 : port;
    }

    public TcpLink(InetAddress address) {
        this(address, 5016);
    }

    public TcpLink(InetAddress address, int port) {
        this.addr = address;
        this.port = port < 1 ? 5016 : port;
    }

    public TcpLink(Socket socket) throws IOException {
        this.sock = socket;
        this.setInputStream(this.sock.getInputStream());
        this.setOutputStream(this.sock.getOutputStream());
    }

    public InetAddress getAddress() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public int getConnectedPort() throws IOException {
        if (this.sock == null) {
            throw new IOException(SOCKET_NOT_OPEN_ERR);
        }
        return this.sock.getPort();
    }

    public int getLocalPort() throws IOException {
        if (this.sock == null) {
            throw new IOException(SOCKET_NOT_OPEN_ERR);
        }
        return this.sock.getLocalPort();
    }

    public boolean isConnected() {
        return this.sock != null && this.sock.isConnected();
    }

    public void setTimeout(int timeout) {
        block3: {
            try {
                this.sockTimeout = timeout;
                if (this.sock != null) {
                    this.sock.setSoTimeout(this.sockTimeout);
                }
            }
            catch (SocketException x) {
                LOG.error("Failed to set timeout on socket: {} ", (Object)x.getMessage());
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(STACK_TRACE_ERR, (Throwable)x);
            }
        }
    }

    public int getTimeout() {
        try {
            return this.sock.getSoTimeout();
        }
        catch (SocketException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(STACK_TRACE_ERR, (Throwable)x);
            }
            return -1;
        }
    }

    public boolean isTimeoutSupported() {
        return true;
    }

    public void connect() throws IOException {
        if (this.sock != null) {
            LOG.debug("Cannot connect a link wrapped around a socket.");
            throw new IllegalStateException();
        }
        LOG.info("Opening TCP socket to {}:{}", (Object)this.addr, (Object)this.port);
        this.sock = new Socket();
        InetSocketAddress sockAddr = new InetSocketAddress(this.addr, this.port);
        this.sock.connect(sockAddr, this.sockTimeout);
        if (this.sockTimeout > 0) {
            LOG.info("Set Socket Timeout to {}", (Object)this.sockTimeout);
            this.sock.setSoTimeout(this.sockTimeout);
        }
        this.setInputStream(new BufferedInputStream(this.sock.getInputStream()));
        this.setOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
    }

    public void disconnect() throws IOException {
        if (this.isConnected()) {
            LOG.info("Shutting down socket connection");
            this.sock.close();
            this.sock = null;
        }
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.sock == null) {
            throw new IOException(SOCKET_NOT_OPEN_ERR);
        }
        return this.sock.getOutputStream();
    }

    protected InputStream getInputStream() throws IOException {
        if (this.sock == null) {
            throw new IOException(SOCKET_NOT_OPEN_ERR);
        }
        return this.sock.getInputStream();
    }
}

